/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.MongoDbConnections;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.Collections;

public class MongoDbTaskContext
extends CdcSourceTaskContext {
    private final Filters filters;
    private final TopicNamingStrategy topicNamingStrategy;
    private final String serverName;
    private final MongoDbConnectorConfig connectorConfig;
    private final Configuration config;

    public MongoDbTaskContext(Configuration config) {
        super((CommonConnectorConfig)new MongoDbConnectorConfig(config), config.getString(MongoDbConnectorConfig.TASK_ID), new MongoDbConnectorConfig(config).getCustomMetricTags(), Collections::emptySet);
        this.filters = new Filters(config);
        this.config = config;
        this.connectorConfig = new MongoDbConnectorConfig(config);
        this.topicNamingStrategy = this.connectorConfig.getTopicNamingStrategy(MongoDbConnectorConfig.TOPIC_NAMING_STRATEGY);
        this.serverName = config.getString(CommonConnectorConfig.TOPIC_PREFIX);
    }

    public TopicNamingStrategy<CollectionId> getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public MongoDbConnectorConfig.CaptureMode getCaptureMode() {
        return this.connectorConfig.getCaptureMode();
    }

    public MongoDbConnection getConnection(EventDispatcher<MongoDbPartition, CollectionId> dispatcher, MongoDbPartition partition) {
        return MongoDbConnections.create(this.config, dispatcher, partition);
    }
}

