/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.eventhandler;

import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import io.debezium.connector.mongodb.sink.eventhandler.EventOperation;
import io.debezium.data.Envelope;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public abstract class EventHandler {
    private static final String OPERATION_TYPE_FIELD_PATH = "op";
    private static final String DDL_FIELD_PATH = "ddl";
    private static final EventOperation NOOP_CDC_OPERATION = (doc, columnNamingStrategy) -> null;
    private final MongoDbSinkConnectorConfig config;
    private final Map<Envelope.Operation, EventOperation> operations = new HashMap<Envelope.Operation, EventOperation>();

    public EventHandler(MongoDbSinkConnectorConfig config) {
        this.config = config;
    }

    public MongoDbSinkConnectorConfig getConfig() {
        return this.config;
    }

    public abstract Optional<WriteModel<BsonDocument>> handle(SinkDocument var1);

    protected void registerOperations(Map<Envelope.Operation, EventOperation> operations) {
        this.operations.putAll(operations);
    }

    public EventOperation getEventOperation(BsonDocument doc) {
        try {
            if (!doc.containsKey((Object)OPERATION_TYPE_FIELD_PATH) && doc.containsKey((Object)DDL_FIELD_PATH)) {
                return NOOP_CDC_OPERATION;
            }
            if (!doc.containsKey((Object)OPERATION_TYPE_FIELD_PATH) || !doc.get((Object)OPERATION_TYPE_FIELD_PATH).isString()) {
                throw new DataException("Value document is missing or CDC operation is not a string");
            }
            EventOperation op = this.operations.get(Envelope.Operation.forCode((String)doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue()));
            if (op == null) {
                throw new DataException("No CDC operation found in mapping for op=" + doc.get((Object)OPERATION_TYPE_FIELD_PATH).asString().getValue());
            }
            return op;
        }
        catch (IllegalArgumentException exc) {
            throw new DataException("Parsing CDC operation failed", (Throwable)exc);
        }
    }
}

