/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.converters;

import io.debezium.connector.mongodb.sink.converters.ByteArrayValueConverter;
import io.debezium.connector.mongodb.sink.converters.JsonStringValueConverter;
import io.debezium.connector.mongodb.sink.converters.LazyBsonDocument;
import io.debezium.connector.mongodb.sink.converters.MapValueConverter;
import io.debezium.connector.mongodb.sink.converters.SchemaValueConverter;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import io.debezium.connector.mongodb.sink.converters.SinkValueConverter;
import io.debezium.sink.DebeziumSinkRecord;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkRecordConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkRecordConverter.class);
    private static final SinkValueConverter SCHEMA_VALUE_CONVERTER = new SchemaValueConverter();
    private static final SinkValueConverter MAP_VALUE_CONVERTER = new MapValueConverter();
    private static final SinkValueConverter JSON_STRING_VALUE_CONVERTER = new JsonStringValueConverter();
    private static final SinkValueConverter BYTE_ARRAY_VALUE_CONVERTER = new ByteArrayValueConverter();

    public SinkDocument convert(DebeziumSinkRecord record) {
        LOGGER.trace("record: {}", (Object)record);
        LazyBsonDocument keyDoc = null;
        if (record.key() != null) {
            keyDoc = new LazyBsonDocument(record, LazyBsonDocument.Type.KEY, (schema, data) -> this.getConverter((Schema)schema, data).convert((Schema)schema, data));
        }
        LazyBsonDocument valueDoc = null;
        if (record.value() != null) {
            valueDoc = new LazyBsonDocument(record, LazyBsonDocument.Type.VALUE, (schema, data) -> this.getConverter((Schema)schema, data).convert((Schema)schema, data));
        }
        return new SinkDocument(keyDoc, valueDoc);
    }

    private SinkValueConverter getConverter(Schema schema, Object data) {
        if (schema != null && data instanceof Struct) {
            LOGGER.debug("Using schema-ed converter");
            return SCHEMA_VALUE_CONVERTER;
        }
        if (data instanceof Map) {
            LOGGER.debug("Using schemaless / map converter");
            return MAP_VALUE_CONVERTER;
        }
        if (data instanceof String) {
            LOGGER.debug("Using JSON string converter");
            return JSON_STRING_VALUE_CONVERTER;
        }
        if (data instanceof byte[]) {
            LOGGER.debug("Using BSON converter");
            return BYTE_ARRAY_VALUE_CONVERTER;
        }
        throw new DataException("No converter found for unexpected object type: " + data.getClass().getName());
    }
}

