/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.IdStrategy;
import io.debezium.connector.mongodb.sink.WriteModelStrategy;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class DeleteDefaultStrategy
implements WriteModelStrategy {
    private final IdStrategy idStrategy;

    public DeleteDefaultStrategy() {
        this(new DefaultIdFieldStrategy());
    }

    public DeleteDefaultStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public IdStrategy getIdStrategy() {
        return this.idStrategy;
    }

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        document.getKeyDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the key document was missing unexpectedly"));
        BsonDocument deleteFilter = this.idStrategy instanceof DefaultIdFieldStrategy ? this.idStrategy.generateId(document, null).asDocument() : new BsonDocument("_id", this.idStrategy.generateId(document, null));
        return new DeleteOneModel((Bson)deleteFilter);
    }

    static class DefaultIdFieldStrategy
    implements IdStrategy {
        DefaultIdFieldStrategy() {
        }

        @Override
        public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
            BsonDocument kd = doc.getKeyDoc().get();
            return kd.containsKey((Object)"_id") ? kd : new BsonDocument("_id", (BsonValue)kd);
        }
    }
}

