/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.converters.bson;

import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBsonType {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBsonType.class);
    private final Schema schema;

    public AbstractBsonType(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public abstract BsonValue toBson(Object var1);

    public BsonValue toBson(Object data, Schema fieldSchema) {
        if (!fieldSchema.isOptional()) {
            if (data == null) {
                throw new DataException("Schema of field \"" + fieldSchema.name() + "\" is not defined as optional but value is null");
            }
            LOGGER.trace("Non-optional field \"{}\" with value \"{}\"", (Object)fieldSchema.name(), data);
            return this.toBson(data);
        }
        if (data != null) {
            LOGGER.trace("Optional field \"{}\" with value \"{}\"", (Object)fieldSchema.name(), data);
            return this.toBson(data);
        }
        if (fieldSchema.defaultValue() != null) {
            LOGGER.trace("Optional field \"{}\" with no data / null value but default value is \"{}\"", (Object)fieldSchema.name(), fieldSchema.defaultValue());
            return this.toBson(fieldSchema.defaultValue());
        }
        LOGGER.trace("Optional field \"{}\" with no data / null value and no default value thus value set to \"{}\"", (Object)fieldSchema.name(), (Object)BsonNull.VALUE);
        return BsonNull.VALUE;
    }
}

