/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.converters;

import io.debezium.connector.mongodb.sink.converters.SinkValueConverter;
import io.debezium.connector.mongodb.sink.converters.bson.AbstractBsonType;
import io.debezium.connector.mongodb.sink.converters.bson.BooleanType;
import io.debezium.connector.mongodb.sink.converters.bson.BytesType;
import io.debezium.connector.mongodb.sink.converters.bson.DateType;
import io.debezium.connector.mongodb.sink.converters.bson.DecimalType;
import io.debezium.connector.mongodb.sink.converters.bson.Float32Type;
import io.debezium.connector.mongodb.sink.converters.bson.Float64Type;
import io.debezium.connector.mongodb.sink.converters.bson.Int16Type;
import io.debezium.connector.mongodb.sink.converters.bson.Int32Type;
import io.debezium.connector.mongodb.sink.converters.bson.Int64Type;
import io.debezium.connector.mongodb.sink.converters.bson.Int8Type;
import io.debezium.connector.mongodb.sink.converters.bson.StringType;
import io.debezium.connector.mongodb.sink.converters.bson.TimeType;
import io.debezium.connector.mongodb.sink.converters.bson.TimestampType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaValueConverter
implements SinkValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValueConverter.class);
    private static final Set<String> LOGICAL_TYPE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.apache.kafka.connect.data.Date", "org.apache.kafka.connect.data.Decimal", "org.apache.kafka.connect.data.Time", "org.apache.kafka.connect.data.Timestamp")));
    private final Map<Schema.Type, AbstractBsonType> schemaTypeToBsonType = new HashMap<Schema.Type, AbstractBsonType>();
    private final Map<String, AbstractBsonType> logicalSchemaTypeToBsonType = new HashMap<String, AbstractBsonType>();

    SchemaValueConverter() {
        this.registerType(new BooleanType());
        this.registerType(new BytesType());
        this.registerType(new Float32Type());
        this.registerType(new Float64Type());
        this.registerType(new Int8Type());
        this.registerType(new Int16Type());
        this.registerType(new Int32Type());
        this.registerType(new Int64Type());
        this.registerType(new StringType());
        this.registerLogicalType(new DateType());
        this.registerLogicalType(new DecimalType());
        this.registerLogicalType(new TimeType());
        this.registerLogicalType(new TimestampType());
    }

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (schema == null || value == null) {
            throw new DataException("Schema-ed conversion failed due to record key and/or value was null");
        }
        return this.toBsonDoc(schema, value).asDocument();
    }

    private void registerType(AbstractBsonType bsonType) {
        this.schemaTypeToBsonType.put(bsonType.getSchema().type(), bsonType);
    }

    private void registerLogicalType(AbstractBsonType bsonType) {
        this.logicalSchemaTypeToBsonType.put(bsonType.getSchema().name(), bsonType);
    }

    private BsonValue toBsonDoc(Schema schema, Object value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        BsonDocument doc = new BsonDocument();
        if (schema.type() == Schema.Type.MAP) {
            Schema fieldSchema = schema.valueSchema();
            Map m = (Map)value;
            for (Object entry : m.keySet()) {
                String key = (String)entry;
                if (fieldSchema.type().isPrimitive()) {
                    doc.put(key, this.getBsonType(fieldSchema).toBson(m.get(key), fieldSchema));
                    continue;
                }
                if (fieldSchema.type().equals((Object)Schema.Type.ARRAY)) {
                    doc.put(key, this.toBsonArray(fieldSchema, m.get(key)));
                    continue;
                }
                if (m.get(key) == null) {
                    doc.put(key, (BsonValue)BsonNull.VALUE);
                    continue;
                }
                doc.put(key, this.toBsonDoc(fieldSchema, m.get(key)));
            }
        } else {
            schema.fields().forEach(f -> doc.put(f.name(), this.processField((Struct)value, (Field)f)));
        }
        return doc;
    }

    private BsonValue toBsonArray(Schema schema, Object value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        Schema fieldSchema = schema.valueSchema();
        BsonArray bsonArray = new BsonArray();
        List myList = (List)value;
        myList.forEach(v -> {
            if (fieldSchema.type().isPrimitive()) {
                if (v == null) {
                    bsonArray.add((BsonValue)BsonNull.VALUE);
                } else {
                    bsonArray.add(this.getBsonType(fieldSchema).toBson(v));
                }
            } else if (fieldSchema.type().equals((Object)Schema.Type.ARRAY)) {
                bsonArray.add(this.toBsonArray(fieldSchema, v));
            } else {
                bsonArray.add(this.toBsonDoc(fieldSchema, v));
            }
        });
        return bsonArray;
    }

    private BsonValue processField(Struct struct, Field field) {
        LOGGER.trace("processing field '{}'", (Object)field.name());
        if (struct.get(field.name()) == null) {
            LOGGER.trace("no field in struct -> adding null");
            return BsonNull.VALUE;
        }
        if (this.isSupportedLogicalType(field.schema())) {
            return this.getBsonType(field.schema()).toBson(struct.get(field), field.schema());
        }
        try {
            switch (field.schema().type()) {
                case BOOLEAN: 
                case FLOAT32: 
                case FLOAT64: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case STRING: 
                case BYTES: {
                    return this.handlePrimitiveField(struct, field);
                }
                case STRUCT: 
                case MAP: {
                    return this.toBsonDoc(field.schema(), struct.get(field));
                }
                case ARRAY: {
                    return this.toBsonArray(field.schema(), struct.get(field));
                }
            }
            throw new DataException("Unexpected / unsupported schema type " + String.valueOf(field.schema().type()));
        }
        catch (Exception e) {
            throw new DataException("Error while processing field " + field.name(), (Throwable)e);
        }
    }

    private BsonValue handlePrimitiveField(Struct struct, Field field) {
        LOGGER.trace("handling primitive type '{}'", (Object)field.schema().type());
        return this.getBsonType(field.schema()).toBson(struct.get(field), field.schema());
    }

    private boolean isSupportedLogicalType(Schema schema) {
        if (schema.name() == null) {
            return false;
        }
        return LOGICAL_TYPE_NAMES.contains(schema.name());
    }

    private AbstractBsonType getBsonType(Schema schema) {
        AbstractBsonType bsonType = this.isSupportedLogicalType(schema) ? this.logicalSchemaTypeToBsonType.get(schema.name()) : this.schemaTypeToBsonType.get(schema.type());
        if (bsonType == null) {
            throw new ConnectException("error no registered bsonType found for " + schema.type().getName());
        }
        return bsonType;
    }
}

