/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.WriteModelStrategy;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class ReplaceDefaultStrategy
implements WriteModelStrategy {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get((Object)"_id");
        if (idValue == null) {
            throw new DataException("Could not build the WriteModel,the `_id` field was missing unexpectedly");
        }
        return new ReplaceOneModel((Bson)new BsonDocument("_id", idValue), (Object)vd, REPLACE_OPTIONS);
    }
}

