/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.shared;

import com.mongodb.ConnectionString;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import org.apache.kafka.common.config.ConfigDef;

public interface SharedMongoDbConnectorConfig {
    public static final Field CONNECTION_STRING = Field.create((String)"mongodb.connection.string").withDisplayName("Connection String").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{SharedMongoDbConnectorConfig::validateConnectionString}).withDescription("Database connection string.");

    private static int validateConnectionString(Configuration config, Field field, Field.ValidationOutput problems) {
        String connectionStringValue = config.getString(field);
        if (connectionStringValue == null) {
            problems.accept(field, null, "Missing connection string");
            return 1;
        }
        try {
            new ConnectionString(connectionStringValue);
        }
        catch (Exception e) {
            problems.accept(field, (Object)connectionStringValue, "Invalid connection string");
            return 1;
        }
        return 0;
    }

    default public ConnectionString resolveConnectionString(Configuration config) {
        String connectionString = config.getString(CONNECTION_STRING);
        return new ConnectionString(connectionString);
    }
}

