/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection.client;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MongoDbClientFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(MongoDbClientFactory.class);

    public MongoClientSettings getMongoClientSettings();

    default public MongoClient getMongoClient() {
        MongoClientSettings clientSettings = this.getMongoClientSettings();
        return MongoClients.create((MongoClientSettings)clientSettings);
    }

    public static KeyStore loadKeyStore(String type, Path path, char[] password) {
        KeyStore keyStore;
        block8: {
            InputStream keys = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(keys, password);
                keyStore = ks;
                if (keys == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keys != null) {
                        try {
                            keys.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOGGER.error("Unable to read key file from '{}'", (Object)path);
                    throw new DebeziumException((Throwable)e);
                }
            }
            keys.close();
        }
        return keyStore;
    }

    public static SSLContext createSSLContext(MongoDbConnectorConfig connectorConfig) {
        try {
            Optional<Path> ksPath = connectorConfig.getSslKeyStore();
            char[] ksPass = connectorConfig.getSslKeyStorePassword();
            String ksType = connectorConfig.getSslKeyStoreType();
            KeyManager[] keyManagers = null;
            if (ksPath.isPresent()) {
                KeyStore ks = MongoDbClientFactory.loadKeyStore(ksType, ksPath.get(), ksPass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, ksPass);
                keyManagers = kmf.getKeyManagers();
            }
            Optional<Path> tsPath = connectorConfig.getSslTrustStore();
            char[] tsPass = connectorConfig.getSslTrustStorePassword();
            String tsType = connectorConfig.getSslTrustStoreType();
            TrustManager[] trustManagers = null;
            if (tsPath.isPresent()) {
                KeyStore ts = MongoDbClientFactory.loadKeyStore(tsType, tsPath.get(), tsPass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOGGER.error("Unable to crate KeyStore/TrustStore manager factory");
            throw new DebeziumException((Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("Unable to initialize SSL context");
            throw new DebeziumException((Throwable)e);
        }
    }
}

