/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.connection.MongoDbAuthProvider;

public class DefaultMongoDbAuthProvider
implements MongoDbAuthProvider {
    private MongoDbConnectorConfig connectorConfig;

    @Override
    public void init(Configuration config) {
        this.connectorConfig = new MongoDbConnectorConfig(config);
    }

    @Override
    public MongoClientSettings.Builder addAuthConfig(MongoClientSettings.Builder settings) {
        String user = this.connectorConfig.getUser();
        String password = this.connectorConfig.getPassword();
        String authSource = this.connectorConfig.getAuthSource();
        if (user != null || password != null) {
            settings.credential(MongoCredential.createCredential((String)user, (String)authSource, (char[])(password != null ? password.toCharArray() : null)));
        }
        return settings;
    }
}

