/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.mongodb.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class MongoDbSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name(connectorConfig.schemaNameAdjuster().adjust("io.debezium.connector.mongo.Source")).field("collection", Schema.STRING_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("lsid", Schema.OPTIONAL_STRING_SCHEMA).field("txnNumber", Schema.OPTIONAL_INT64_SCHEMA).field("wallTime", Schema.OPTIONAL_INT64_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        Struct struct = super.commonStruct((AbstractSourceInfo)sourceInfo).put("collection", (Object)sourceInfo.collectionId().name()).put("ord", (Object)sourceInfo.position().getInc());
        if (sourceInfo.position().getChangeStreamSessionTxnId() != null) {
            struct.put("lsid", (Object)sourceInfo.position().getChangeStreamSessionTxnId().lsid).put("txnNumber", (Object)sourceInfo.position().getChangeStreamSessionTxnId().txnNumber);
        }
        if (sourceInfo.wallTime() != 0L) {
            struct.put("wallTime", (Object)sourceInfo.wallTime());
        }
        return struct;
    }
}

