/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.events;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.SplitEvent;
import com.mongodb.client.model.changestream.UpdateDescription;
import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.events.BufferingChangeStreamCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitEventHandler<TResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitEventHandler.class);
    final List<ChangeStreamDocument<TResult>> fragmentBuffer = new ArrayList<ChangeStreamDocument<TResult>>(16);

    public Optional<ChangeStreamDocument<TResult>> handle(BufferingChangeStreamCursor.ResumableChangeStreamEvent<TResult> event) {
        ChangeStreamDocument document = event.document.orElseThrow();
        return this.handle(document);
    }

    public Optional<ChangeStreamDocument<TResult>> handle(ChangeStreamDocument<TResult> event) {
        SplitEvent split = event.getSplitEvent();
        if (split != null) {
            int currentFragment = split.getFragment();
            int totalFragments = split.getOf();
            LOGGER.trace("Change Stream event is a fragment: {} of {}", (Object)currentFragment, (Object)totalFragments);
            this.fragmentBuffer.add(event);
            if (currentFragment != totalFragments) {
                return Optional.empty();
            }
            ChangeStreamDocument<TResult> merged = SplitEventHandler.mergeEventFragments(this.fragmentBuffer);
            this.fragmentBuffer.clear();
            return Optional.of(merged);
        }
        if (!this.fragmentBuffer.isEmpty()) {
            LOGGER.error("Expected event fragment but a new event arrived");
            throw new DebeziumException("Missing event fragment");
        }
        return Optional.of(event);
    }

    public boolean isEmpty() {
        return this.fragmentBuffer.isEmpty();
    }

    private static <TResult> ChangeStreamDocument<TResult> mergeEventFragments(List<ChangeStreamDocument<TResult>> events) {
        String operationTypeString = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getOperationTypeString);
        BsonDocument resumeToken = events.get(events.size() - 1).getResumeToken();
        BsonDocument namespaceDocument = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getNamespaceDocument);
        BsonDocument destinationNamespaceDocument = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getDestinationNamespaceDocument);
        Object fullDocument = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getFullDocument);
        Object fullDocumentBeforeChange = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getFullDocumentBeforeChange);
        BsonDocument documentKey = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getDocumentKey);
        BsonTimestamp clusterTime = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getClusterTime);
        UpdateDescription updateDescription = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getUpdateDescription);
        BsonInt64 txnNumber = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getTxnNumber);
        BsonDocument lsid = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getLsid);
        BsonDateTime wallTime = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getWallTime);
        BsonDocument extraElements = SplitEventHandler.firstOrNull(events, ChangeStreamDocument::getExtraElements);
        return new ChangeStreamDocument(operationTypeString, resumeToken, namespaceDocument, destinationNamespaceDocument, fullDocument, fullDocumentBeforeChange, documentKey, clusterTime, updateDescription, txnNumber, lsid, wallTime, null, extraElements);
    }

    private static <TResult, T> T firstOrNull(Collection<ChangeStreamDocument<TResult>> events, Function<ChangeStreamDocument<TResult>, T> getter) {
        return events.stream().map(getter).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

