/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.connection.MongoDbAuthProvider;

public class DefaultMongoDbAuthProvider
implements MongoDbAuthProvider {
    private String username;
    private String password;
    private String adminDbName;

    @Override
    public void init(Configuration config) {
        this.username = config.getString(MongoDbConnectorConfig.USER);
        this.password = config.getString(MongoDbConnectorConfig.PASSWORD);
        this.adminDbName = config.getString(MongoDbConnectorConfig.AUTH_SOURCE);
    }

    @Override
    public MongoClientSettings.Builder addAuthConfig(MongoClientSettings.Builder settings) {
        if (this.username != null || this.password != null) {
            settings.credential(MongoCredential.createCredential((String)this.username, (String)this.adminDbName, this.password != null ? this.password.toCharArray() : null));
        }
        return settings;
    }
}

