/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.snapshot;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.snapshot.MongoDbIncrementalSnapshotChangeEventSource;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.source.snapshot.incremental.WatermarkWindowCloser;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDeleteWindowCloser
implements WatermarkWindowCloser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbDeleteWindowCloser.class);
    private static final String DOCUMENT_ID = "_id";
    private final MongoDbConnection mongoDbConnection;
    private final CollectionId collectionId;
    private final MongoDbIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource;

    public MongoDbDeleteWindowCloser(MongoDbConnection mongoDbConnection, CollectionId collectionId, MongoDbIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource) {
        this.mongoDbConnection = mongoDbConnection;
        this.collectionId = collectionId;
        this.incrementalSnapshotChangeEventSource = incrementalSnapshotChangeEventSource;
    }

    public void closeWindow(Partition partition, OffsetContext offsetContext, String chunkId) throws InterruptedException {
        this.mongoDbConnection.execute("Deleting open window for chunk '" + chunkId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(this.collectionId.dbName());
            MongoCollection collection = database.getCollection(this.collectionId.name());
            LOGGER.trace("Deleting open window for chunk = '{}'", (Object)chunkId);
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)(chunkId + "-open"));
            collection.deleteOne((Bson)signal);
        }));
        try {
            this.incrementalSnapshotChangeEventSource.closeWindow((MongoDbPartition)partition, chunkId + "-close", offsetContext);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Failed to close window {} successful.", (Object)chunkId);
            Thread.currentThread().interrupt();
        }
    }
}

