/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.MongoDbAuthProvider;
import io.debezium.connector.mongodb.connection.MongoDbClientFactory;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionContext.class);
    private final Configuration config;
    private final MongoDbConnectorConfig connectorConfig;
    private final MongoDbClientFactory clientFactory;

    public ConnectionContext(Configuration config) {
        this.config = config;
        this.connectorConfig = new MongoDbConnectorConfig(config);
        MongoDbAuthProvider authProvider = (MongoDbAuthProvider)config.getInstance(MongoDbConnectorConfig.AUTH_PROVIDER_CLASS, MongoDbAuthProvider.class);
        int connectTimeoutMs = config.getInteger(MongoDbConnectorConfig.CONNECT_TIMEOUT_MS);
        int heartbeatFrequencyMs = config.getInteger(MongoDbConnectorConfig.HEARTBEAT_FREQUENCY_MS);
        int socketTimeoutMs = config.getInteger(MongoDbConnectorConfig.SOCKET_TIMEOUT_MS);
        int serverSelectionTimeoutMs = config.getInteger(MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS);
        authProvider.init(config);
        this.clientFactory = MongoDbClientFactory.create(settings -> {
            settings.applyToSocketSettings(builder -> builder.connectTimeout(connectTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)serverSelectionTimeoutMs, TimeUnit.MILLISECONDS)).applyToServerSettings(builder -> builder.heartbeatFrequency((long)heartbeatFrequencyMs, TimeUnit.MILLISECONDS)).applyToSocketSettings(builder -> builder.connectTimeout(connectTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)serverSelectionTimeoutMs, TimeUnit.MILLISECONDS)).applyToSslSettings(builder -> builder.enabled(this.connectorConfig.isSslEnabled()).invalidHostNameAllowed(this.connectorConfig.isSslAllowInvalidHostnames()).context(ConnectionContext.createSSLContext(this.connectorConfig)));
            authProvider.addAuthConfig((MongoClientSettings.Builder)settings);
        });
    }

    static KeyStore loadKeyStore(String type, Path path, char[] password) {
        KeyStore keyStore;
        block8: {
            InputStream keys = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(keys, password);
                keyStore = ks;
                if (keys == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keys != null) {
                        try {
                            keys.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOGGER.error("Unable to read key file from '{}'", (Object)path);
                    throw new DebeziumException((Throwable)e);
                }
            }
            keys.close();
        }
        return keyStore;
    }

    static SSLContext createSSLContext(MongoDbConnectorConfig connectorConfig) {
        try {
            Optional<Path> ksPath = connectorConfig.getSslKeyStore();
            char[] ksPass = connectorConfig.getSslKeyStorePassword();
            String ksType = connectorConfig.getSslKeyStoreType();
            KeyManager[] keyManagers = null;
            if (ksPath.isPresent()) {
                KeyStore ks = ConnectionContext.loadKeyStore(ksType, ksPath.get(), ksPass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, ksPass);
                keyManagers = kmf.getKeyManagers();
            }
            Optional<Path> tsPath = connectorConfig.getSslTrustStore();
            char[] tsPass = connectorConfig.getSslTrustStorePassword();
            String tsType = connectorConfig.getSslTrustStoreType();
            TrustManager[] trustManagers = null;
            if (tsPath.isPresent()) {
                KeyStore ts = ConnectionContext.loadKeyStore(tsType, tsPath.get(), tsPass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            }
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOGGER.error("Unable to crate KeyStore/TrustStore manager factory");
            throw new DebeziumException((Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("Unable to initialize SSL context");
            throw new DebeziumException((Throwable)e);
        }
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public String connectionSeed() {
        return this.config.getString(MongoDbConnectorConfig.CONNECTION_STRING);
    }

    public ConnectionString connectionString() {
        return new ConnectionString(this.connectionSeed());
    }

    public String maskedConnectionSeed() {
        return ConnectionStrings.mask(this.connectionSeed());
    }

    public Duration pollInterval() {
        return Duration.ofMillis(this.config.getLong(MongoDbConnectorConfig.MONGODB_POLL_INTERVAL_MS));
    }

    public MongoClient connect() {
        return this.clientFactory.client(this.connectionString());
    }

    public MongoDbConnection connect(ReplicaSet replicaSet, Filters filters, MongoDbConnection.ErrorHandler errorHandler) {
        return new MongoDbConnection(replicaSet, this.clientFactory, this.connectorConfig, filters, errorHandler);
    }
}

