/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbIncrementalSnapshotContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSetPartition;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;

public class MongoDbOffsetContext
implements OffsetContext {
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;
    private final Map<ReplicaSet, ReplicaSetPartition> replicaSetPartitions = new ConcurrentHashMap<ReplicaSet, ReplicaSetPartition>();
    private final Map<ReplicaSet, ReplicaSetOffsetContext> replicaSetOffsetContexts = new ConcurrentHashMap<ReplicaSet, ReplicaSetOffsetContext>();
    private final IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext;

    public MongoDbOffsetContext(SourceInfo sourceInfo, TransactionContext transactionContext, IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext) {
        this.sourceInfo = sourceInfo;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public MongoDbOffsetContext(SourceInfo sourceInfo, TransactionContext transactionContext, IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext, Map<ReplicaSet, Document> offsets) {
        this(sourceInfo, transactionContext, incrementalSnapshotContext);
        offsets.forEach((replicaSet, document) -> sourceInfo.opLogEvent(replicaSet.replicaSetName(), (Document)document, (Document)document, 0L));
    }

    void startReplicaSetSnapshot(String replicaSetName) {
        this.sourceInfo.startInitialSync(replicaSetName);
    }

    void stopReplicaSetSnapshot(String replicaSetName) {
        this.sourceInfo.stopInitialSync(replicaSetName);
    }

    public Map<String, ?> getOffset() {
        throw new UnsupportedOperationException();
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfo.schema();
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && this.sourceInfo.isSnapshotRunning();
    }

    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
    }

    public void preSnapshotCompletion() {
    }

    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void incrementalSnapshotEvents() {
        this.sourceInfo.setSnapshot(SnapshotRecord.INCREMENTAL);
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public void event(DataCollectionId collectionId, Instant timestamp) {
        throw new UnsupportedOperationException();
    }

    public ReplicaSetPartition getReplicaSetPartition(ReplicaSet replicaSet) {
        return this.replicaSetPartitions.computeIfAbsent(replicaSet, rs -> new ReplicaSetPartition(this.sourceInfo.serverId(), rs.replicaSetName()));
    }

    public ReplicaSetOffsetContext getReplicaSetOffsetContext(ReplicaSet replicaSet) {
        return this.replicaSetOffsetContexts.computeIfAbsent(replicaSet, rs -> new ReplicaSetOffsetContext(this, (ReplicaSet)rs, this.sourceInfo, this.incrementalSnapshotContext));
    }

    public String toString() {
        return "MongoDbOffsetContext [sourceInfo=" + (Object)((Object)this.sourceInfo) + "]";
    }

    public static class Loader {
        private final ReplicaSets replicaSets;
        private final SourceInfo sourceInfo;

        public Loader(MongoDbConnectorConfig connectorConfig, ReplicaSets replicaSets) {
            this.sourceInfo = new SourceInfo(connectorConfig);
            this.replicaSets = replicaSets;
        }

        public Collection<Map<String, String>> getPartitions() {
            ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
            this.replicaSets.onEachReplicaSet(replicaSet -> {
                String name = replicaSet.replicaSetName();
                if (name != null) {
                    Map<String, String> partition = this.sourceInfo.partition(name);
                    partitions.add(partition);
                }
            });
            return partitions;
        }

        public MongoDbOffsetContext loadOffsets(Map<Map<String, String>, Map<String, Object>> offsets) {
            offsets.forEach(this.sourceInfo::setOffsetFor);
            return new MongoDbOffsetContext(this.sourceInfo, new TransactionContext(), MongoDbIncrementalSnapshotContext.load(offsets.values().iterator().next(), false));
        }
    }
}

