/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import org.apache.kafka.connect.errors.ConnectException;

public class MongoDbErrorHandler
extends ErrorHandler {
    public MongoDbErrorHandler(MongoDbConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        super(MongoDbConnector.class, (CommonConnectorConfig)connectorConfig, queue);
    }

    protected boolean isRetriable(Throwable throwable) {
        if (throwable instanceof ConnectException) {
            for (Throwable cause = throwable.getCause(); cause != null && cause != throwable; cause = cause.getCause()) {
                if (!(cause instanceof MongoSocketException) && !(cause instanceof MongoTimeoutException) && !(cause instanceof MongoExecutionTimeoutException) && !(cause instanceof MongoNodeIsRecoveringException)) continue;
                return true;
            }
        }
        return false;
    }
}

