/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2SourceInfoStructMaker;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.Module;
import io.debezium.connector.db2.platform.Db2PlatformAdapter;
import io.debezium.connector.db2.platform.LuwPlatform;
import io.debezium.connector.db2.platform.ZOsPlatform;
import io.debezium.document.Document;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;

public class Db2ConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final String DEFAULT_CDC_SCHEMA = "ASNCDC";
    public static final int DEFAULT_QUERY_FETCH_SIZE = 10000;
    protected static final int DEFAULT_PORT = 50000;
    public static final Field Z_STOP_LSN_IGNORE = Field.create((String)"z.stop.lsn.ignore").withDisplayName("z/OS ignore stop LSN").withDefault(false).withType(ConfigDef.Type.BOOLEAN).withDescription("If true, causes the connector to ignore the stop LSN value from the IBMSNAP_REGISTER.CD_OLD_SYNCHPOINT column when polling. Apply this if events are getting dropped due to the stop LSN being smaller than the current range of LSNs. Only applies to z/OS platform.");
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(50000);
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.REPEATABLE_READ).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. In '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' mode no table locks or any *long-lasting* row-level locks are acquired, but connector does not guarantee snapshot consistency.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.EXCLUSIVE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)2)).withDescription("Controls how the connector holds locks on tables while performing the schema snapshot when `snapshot.isolation.mode` is `REPEATABLE_READ` or `EXCLUSIVE`. The 'exclusive' which means the connector will hold a table lock for exclusive table access for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this is done using a flashback query that requires no locks. However, in some cases it may be desirable to avoid locks entirely which can be done by specifying 'none'. This mode is only safe to use if no schema changes are happening while the snapshot is taken.");
    public static final Field CDC_CONTROL_SCHEMA = Field.create((String)"cdc.control.schema").withDisplayName("CDC control schema").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault("ASNCDC").withDescription("The name of the schema where CDC control structures are located; defaults to 'ASNCDC'");
    public static final Field CDC_CHANGE_TABLES_SCHEMA = Field.create((String)"cdc.change.tables.schema").withDisplayName("CDC change tables schema").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault("ASNCDC").withDescription("The name of the schema where CDC change tables are located; defaults to 'ASNCDC'");
    public static final Field DB2_PLATFORM = Field.create((String)"db2.platform").withDisplayName("Db2 platform").withEnum(Db2Platform.class, (Enum)Db2Platform.LUW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Informs connector which Db2 implementation platform it is connected to. The default is '" + String.valueOf((Object)Db2Platform.LUW) + "', which means Windows, UNIX, Linux. Using a value of '" + String.valueOf((Object)Db2Platform.Z) + "' ensures that the Db2 for z/OS specific SQL statements are used.");
    public static final Field QUERY_FETCH_SIZE = CommonConnectorConfig.QUERY_FETCH_SIZE.withDescription("The maximum number of records that should be loaded into memory while streaming. A value of '0' uses the default JDBC fetch size. The default value is '10000'.").withDefault(10000);
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(Db2SourceInfoStructMaker.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Db2").excluding(new Field[]{CommonConnectorConfig.QUERY_FETCH_SIZE, CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER}).type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, DATABASE_NAME}).connector(new Field[]{SNAPSHOT_MODE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, SCHEMA_NAME_ADJUSTMENT_MODE, QUERY_FETCH_SIZE, CDC_CONTROL_SCHEMA, CDC_CHANGE_TABLES_SCHEMA, DB2_PLATFORM}).events(new Field[]{SOURCE_INFO_STRUCT_MAKER}).excluding(new Field[]{SCHEMA_INCLUDE_LIST, SCHEMA_EXCLUDE_LIST, BINARY_HANDLING_MODE, INCLUDE_SCHEMA_COMMENTS, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, SNAPSHOT_MAX_THREADS, DatabaseHeartbeatImpl.HEARTBEAT_ACTION_QUERY}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final String databaseName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final SnapshotLockingMode snapshotLockingMode;
    private final Db2Platform db2Platform;
    private final boolean zStopLsnIgnore;
    private final String cdcChangeTablesSchema;
    private final String cdcControlSchema;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public Db2ConnectorConfig(Configuration config) {
        super(Db2Connector.class, config, (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), false, ColumnFilterMode.SCHEMA, false);
        this.databaseName = config.getString(DATABASE_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
        this.db2Platform = Db2Platform.parse(config.getString(DB2_PLATFORM), DB2_PLATFORM.defaultValueAsString());
        this.zStopLsnIgnore = config.getBoolean(Z_STOP_LSN_IGNORE);
        this.cdcChangeTablesSchema = config.getString(CDC_CHANGE_TABLES_SCHEMA);
        this.cdcControlSchema = config.getString(CDC_CONTROL_SCHEMA);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public Optional<SnapshotLockingMode> getSnapshotLockingMode() {
        return Optional.of(this.snapshotLockingMode);
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public Db2Platform getDb2Platform() {
        return this.db2Platform;
    }

    public boolean isZStopLsnIgnore() {
        return this.zStopLsnIgnore;
    }

    public String getCdcChangeTablesSchema() {
        return this.cdcChangeTablesSchema;
    }

    public String getCdcControlSchema() {
        return this.cdcControlSchema;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString((CharSequence)"change_lsn")).compareTo(Lsn.valueOf(desired.getString((CharSequence)"change_lsn"))) < 1;
            }
        };
    }

    public String getContextName() {
        return Module.contextName();
    }

    public Map<DataCollectionId, String> getSnapshotSelectOverridesByTable() {
        String tableListString = this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
        if (tableListString == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        List tableList = Strings.listOfTrimmed((String)tableListString, (char)',', s -> s);
        for (String table : tableList) {
            snapshotSelectOverridesByTable.put(TableId.parse((String)table, (boolean)false), this.getConfig().getString(String.valueOf(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE) + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return t.schema() != null && !t.table().toLowerCase().startsWith("ibmsnap_") && !t.schema().toUpperCase().startsWith(Db2ConnectorConfig.DEFAULT_CDC_SCHEMA) && !t.schema().toUpperCase().startsWith("SYSTOOLS") && !t.table().toLowerCase().startsWith("ibmqrep_");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        INITIAL_ONLY("initial_only"),
        SCHEMA_ONLY("schema_only"),
        NO_DATA("no_data"),
        RECOVERY("recovery"),
        WHEN_NEEDED("when_needed"),
        CONFIGURATION_BASED("configuration_based"),
        CUSTOM("custom");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        NONE("none"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Db2Platform implements EnumeratedValue
    {
        LUW("LUW"){

            @Override
            public Db2PlatformAdapter createAdapter(Db2ConnectorConfig config) {
                return new LuwPlatform(config);
            }

            @Override
            public String platfromName() {
                return "LUW";
            }
        }
        ,
        Z("ZOS"){

            @Override
            public Db2PlatformAdapter createAdapter(Db2ConnectorConfig config) {
                return new ZOsPlatform(config);
            }

            @Override
            public String platfromName() {
                return "z/OS";
            }
        };

        private final String value;

        private Db2Platform(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public abstract Db2PlatformAdapter createAdapter(Db2ConnectorConfig var1);

        public abstract String platfromName();

        public static Db2Platform parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (Db2Platform option : Db2Platform.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static Db2Platform parse(String value, String defaultValue) {
            Db2Platform mode = Db2Platform.parse(value);
            if (mode == null && defaultValue != null) {
                mode = Db2Platform.parse(defaultValue);
            }
            return mode;
        }
    }
}

