/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import java.math.BigDecimal;
import java.time.ZoneOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class Db2ValueConverters
extends JdbcValueConverters {
    public Db2ValueConverters() {
    }

    public Db2ValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode) {
        super(decimalMode, temporalPrecisionMode, ZoneOffset.UTC, null, null, null);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        switch (column.jdbcType()) {
            case -6: {
                return SchemaBuilder.int16();
            }
            case 1111: {
                if (!Db2ValueConverters.matches(column.typeName().toUpperCase(), "DECFLOAT")) break;
                return this.decfloatSchema(column);
            }
        }
        return super.schemaBuilder(column);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -6: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 1111: {
                if (!Db2ValueConverters.matches(column.typeName().toUpperCase(), "DECFLOAT")) break;
                return data -> this.convertDecfloat(column, fieldDefn, data, this.decimalMode);
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Object convertDecfloat(Column column, Field fieldDefn, Object data, JdbcValueConverters.DecimalMode mode) {
        SpecialValueDecimal value;
        if (data instanceof SpecialValueDecimal) {
            value = (SpecialValueDecimal)data;
            if (value.getDecimalValue().isEmpty()) {
                return SpecialValueDecimal.fromLogical((SpecialValueDecimal)value, (JdbcValueConverters.DecimalMode)mode, (String)column.name());
            }
        } else {
            Object o = this.toBigDecimal(column, fieldDefn, data);
            if (!(o instanceof BigDecimal)) {
                return o;
            }
            value = new SpecialValueDecimal((BigDecimal)o);
        }
        BigDecimal newDecimal = this.withScaleAdjustedIfNeeded(column, (BigDecimal)value.getDecimalValue().get());
        if (mode == JdbcValueConverters.DecimalMode.PRECISE) {
            if ((newDecimal = newDecimal.stripTrailingZeros()).scale() < 0) {
                newDecimal = newDecimal.setScale(0);
            }
            return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)new SpecialValueDecimal(newDecimal));
        }
        return SpecialValueDecimal.fromLogical((SpecialValueDecimal)new SpecialValueDecimal(newDecimal), (JdbcValueConverters.DecimalMode)mode, (String)column.name());
    }

    protected int getTimePrecision(Column column) {
        return (Integer)column.scale().get();
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampWithZone(column, fieldDefn, data);
    }

    protected static boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    private SchemaBuilder decfloatSchema(Column column) {
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE) {
            return VariableScaleDecimal.builder();
        }
        return SpecialValueDecimal.builder((JdbcValueConverters.DecimalMode)this.decimalMode, (int)column.length(), (int)column.scale().orElse(0));
    }
}

