/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DefaultValueConverter;
import io.debezium.connector.db2.Db2ValueConverters;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2DatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2DatabaseSchema.class);

    public Db2DatabaseSchema(Db2ConnectorConfig connectorConfig, Db2ValueConverters valueConverters, SchemaNameAdjuster schemaNameAdjuster, TopicNamingStrategy<TableId> topicNamingStrategy, Db2Connection connection, CustomConverterRegistry customConverterRegistry) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicNamingStrategy, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)valueConverters, (DefaultValueConverter)new Db2DefaultValueConverter(valueConverters, connection), schemaNameAdjuster, customConverterRegistry, connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getFieldNamer(), false), false, connectorConfig.getKeyMapper());
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        Table table = (Table)schemaChange.getTables().iterator().next();
        this.buildAndRegisterSchema(table);
        this.tables().overwriteTable(table);
        TableChanges tableChanges = null;
        if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.CREATE) {
            tableChanges = new TableChanges();
            tableChanges.create(table);
        } else if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.ALTER) {
            tableChanges = new TableChanges();
            tableChanges.alter(table);
        }
        this.record(schemaChange, tableChanges);
    }

    protected DdlParser getDdlParser() {
        return null;
    }
}

