/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2ObjectNameQuoter;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.TxLogPosition;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2SnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<Db2Partition, Db2OffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2SnapshotChangeEventSource.class);
    private final Db2ConnectorConfig connectorConfig;
    private final Db2Connection jdbcConnection;

    public Db2SnapshotChangeEventSource(Db2ConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<Db2Connection> connectionFactory, Db2DatabaseSchema schema, EventDispatcher<Db2Partition, TableId> dispatcher, Clock clock, SnapshotProgressListener<Db2Partition> snapshotProgressListener, NotificationService<Db2Partition, Db2OffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, connectionFactory, (RelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener, notificationService, snapshotterService);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = (Db2Connection)connectionFactory.mainConnection();
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> prepare(Db2Partition partition, boolean onDemand) {
        return new Db2SnapshotContext(partition, this.jdbcConnection.getRealDatabaseName(), onDemand);
    }

    protected void connectionCreated(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws Exception {
        ((Db2SnapshotContext)snapshotContext).isolationLevelBeforeStart = this.jdbcConnection.connection().getTransactionIsolation();
    }

    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> ctx) throws Exception {
        return this.jdbcConnection.readTableNames(null, null, null, new String[]{"TABLE"});
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(1);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.READ_COMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(2);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.EXCLUSIVE || this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().setTransactionIsolation(4);
            ((Db2SnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("db2_schema_snapshot");
            LOGGER.info("Executing schema locking");
            try (Statement statement = this.jdbcConnection.connection().createStatement(1003, 1007);){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + String.valueOf(tableId));
                    }
                    Optional lockingStatement = this.snapshotterService.getSnapshotLock().tableLockingStatement(this.connectorConfig.snapshotLockTimeout(), this.quoteTableName(tableId));
                    if (!lockingStatement.isPresent()) continue;
                    LOGGER.info("Locking table {}", (Object)tableId);
                    statement.executeQuery((String)lockingStatement.get()).close();
                }
            }
        } else {
            throw new IllegalStateException("Unknown locking mode specified.");
        }
    }

    private String quoteTableName(TableId tableId) {
        return String.format("%s.%s", Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema()), Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.table()));
    }

    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().rollback(((Db2SnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
            LOGGER.info("Schema locks released.");
        }
    }

    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> ctx, Db2OffsetContext previousOffset) throws Exception {
        if (this.connectorConfig.getSnapshotMode() != Db2ConnectorConfig.SnapshotMode.ALWAYS && previousOffset != null) {
            ctx.offset = previousOffset;
            this.tryStartingSnapshot(ctx);
            return;
        }
        ctx.offset = new Db2OffsetContext(this.connectorConfig, TxLogPosition.valueOf(this.jdbcConnection.getMaxLsn()), false, false);
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, Db2OffsetContext previousOffset, SnapshottingTask snapshottingTask) throws SQLException, InterruptedException {
        Set schemas = snapshotContext.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            LOGGER.info("Reading structure of schema '{}'", (Object)schema);
            Tables.TableFilter tableFilter = snapshottingTask.isOnDemand() ? Tables.TableFilter.fromPredicate(snapshotContext.capturedTables::contains) : this.connectorConfig.getTableFilters().dataCollectionFilter();
            this.jdbcConnection.readSchema(snapshotContext.tables, null, schema, tableFilter, null, false);
        }
    }

    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, Table table) {
        return SchemaChangeEvent.ofSnapshotCreate((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, (String)snapshotContext.catalogName, (Table)table);
    }

    protected void completed(AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    protected void aborted(AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    private void close(AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) {
        try {
            this.jdbcConnection.connection().setTransactionIsolation(((Db2SnapshotContext)snapshotContext).isolationLevelBeforeStart);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set transaction isolation level.", e);
        }
    }

    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        return this.snapshotterService.getSnapshotQuery().snapshotQuery(this.quoteTableName(tableId), columns);
    }

    protected Db2OffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) {
        return new Db2OffsetContext.Loader(this.connectorConfig).load(((Db2OffsetContext)snapshotContext.offset).getOffset());
    }

    private static class Db2SnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> {
        private int isolationLevelBeforeStart;
        private Savepoint preSchemaSnapshotSavepoint;

        Db2SnapshotContext(Db2Partition partition, String catalogName, boolean onDemand) {
            super((Partition)partition, catalogName, onDemand);
        }
    }
}

