/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.AbstractPartition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Objects;

public class BinlogPartition
extends AbstractPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public BinlogPartition(String serverName, String databaseName) {
        super(databaseName);
        this.serverName = serverName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BinlogPartition that = (BinlogPartition)((Object)o);
        return Objects.equals(this.serverName, that.serverName);
    }

    public int hashCode() {
        return Objects.hash(this.serverName);
    }

    public String toString() {
        return "BinlogPartition{serverName='" + this.serverName + "'} " + super.toString();
    }
}

