/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.history;

import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.gtid.GtidSetFactory;
import io.debezium.document.Document;
import io.debezium.relational.history.HistoryRecordComparator;
import java.util.function.Predicate;

public abstract class BinlogHistoryRecordComparator
extends HistoryRecordComparator {
    private final Predicate<String> gtidSourceFilter;
    private final GtidSetFactory gtidSetFactory;

    public BinlogHistoryRecordComparator(Predicate<String> gtidSourceFilter, GtidSetFactory gtidSetFactory) {
        this.gtidSourceFilter = gtidSourceFilter;
        this.gtidSetFactory = gtidSetFactory;
    }

    public boolean isPositionAtOrBefore(Document recorded, Document desired) {
        int desiredRow;
        int desiredEventCount;
        int desiredPosition;
        BinlogFileName desiredFileName;
        String recordedGtid = this.getGtidSet(recorded);
        String desiredGtid = this.getGtidSet(desired);
        if (desiredGtid != null) {
            if (recordedGtid != null) {
                GtidSet recordedGtidSet = this.gtidSetFactory.createGtidSet(recordedGtid);
                GtidSet desiredGtidSet = this.gtidSetFactory.createGtidSet(desiredGtid);
                if (this.gtidSourceFilter != null) {
                    recordedGtidSet = recordedGtidSet.retainAll(this.gtidSourceFilter);
                    desiredGtidSet = desiredGtidSet.retainAll(this.gtidSourceFilter);
                }
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    int desiredEventCount2;
                    if (!this.isSnapshot(recorded) && this.isSnapshot(desired)) {
                        return false;
                    }
                    int recordedEventCount = recorded.getInteger((CharSequence)"event", 0);
                    int diff = recordedEventCount - (desiredEventCount2 = desired.getInteger((CharSequence)"event", 0));
                    return diff <= 0;
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtid != null) {
            return false;
        }
        if (this.getServerId(recorded) != this.getServerId(desired)) {
            return this.getTimestamp(recorded) <= this.getTimestamp(desired);
        }
        BinlogFileName recordedFileName = this.getBinlogFileName(recorded);
        int fileNameCheck = recordedFileName.compareTo(desiredFileName = this.getBinlogFileName(desired));
        if (fileNameCheck != 0) {
            return fileNameCheck < 0;
        }
        int recordedPosition = this.getBinlogPosition(recorded);
        int positionCheck = recordedPosition - (desiredPosition = this.getBinlogPosition(desired));
        if (positionCheck != 0) {
            return positionCheck < 0;
        }
        int recordedEventCount = this.getEventsToSkip(recorded);
        int eventCountCheck = recordedEventCount - (desiredEventCount = this.getEventsToSkip(desired));
        if (eventCountCheck != 0) {
            return eventCountCheck < 0;
        }
        int recordedRow = this.getBinlogRowInEvent(recorded);
        int rowCheck = recordedRow - (desiredRow = this.getBinlogRowInEvent(desired));
        return rowCheck <= 0;
    }

    protected String getGtidSet(Document document) {
        return document.getString((CharSequence)"gtids");
    }

    protected int getServerId(Document document) {
        return document.getInteger((CharSequence)"server_id", 0);
    }

    protected boolean isSnapshot(Document document) {
        return document.has((CharSequence)"snapshot");
    }

    protected long getTimestamp(Document document) {
        return document.getLong((CharSequence)"ts_ms", 0L);
    }

    protected BinlogFileName getBinlogFileName(Document document) {
        return BinlogFileName.of(document.getString((CharSequence)"file"));
    }

    protected int getBinlogPosition(Document document) {
        return document.getInteger((CharSequence)"pos", -1);
    }

    protected int getEventsToSkip(Document document) {
        return document.getInteger((CharSequence)"event", 0);
    }

    protected int getBinlogRowInEvent(Document document) {
        return document.getInteger((CharSequence)"row", -1);
    }

    protected static class BinlogFileName
    implements Comparable<BinlogFileName> {
        private final String baseName;
        private final long extension;

        private BinlogFileName(String baseName, long extension) {
            this.baseName = baseName;
            this.extension = extension;
        }

        @Override
        public int compareTo(BinlogFileName other) {
            if (!this.baseName.equals(other.baseName)) {
                throw new IllegalArgumentException("Cannot compare binlog filenames with different base names");
            }
            return Long.compare(this.extension, other.extension);
        }

        public String toString() {
            return "BinlogFileName [baseName=" + this.baseName + ", extension=" + this.extension + "]";
        }

        public static BinlogFileName of(String fileName) {
            long extension;
            int index = fileName.lastIndexOf(46);
            if (index == -1) {
                throw new IllegalArgumentException("Filename does not have an extension:" + fileName);
            }
            String baseFileName = fileName.substring(0, index);
            String stringExtension = fileName.substring(index + 1);
            try {
                extension = Long.parseLong(stringExtension);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse binlog filename extension: " + fileName, e);
            }
            return new BinlogFileName(baseFileName, extension);
        }
    }
}

