/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;

public abstract class BinlogReadOnlyIncrementalSnapshotContext<T>
extends AbstractIncrementalSnapshotContext<T> {
    public static final String SIGNAL_OFFSET = "incremental_snapshot_signal_offset";
    private Long signalOffset;

    public BinlogReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    public Long getSignalOffset() {
        return this.signalOffset;
    }

    public void setSignalOffset(Long signalOffset) {
        this.signalOffset = signalOffset;
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        Map snapshotOffset = super.store(offset);
        snapshotOffset.put(SIGNAL_OFFSET, this.signalOffset);
        return snapshotOffset;
    }

    public String getCurrentGtid(OffsetContext offsetContext) {
        return offsetContext.getSourceInfo().getString("gtid");
    }

    public abstract void setLowWatermark(GtidSet var1);

    public abstract void setHighWatermark(GtidSet var1);

    public abstract boolean reachedHighWatermark(String var1);

    public abstract boolean hasServerIdentifierChanged();

    public abstract boolean updateWindowState(OffsetContext var1);

    public abstract boolean watermarksChanged();

    public abstract void closeWindow();

    protected static <U> IncrementalSnapshotContext<U> init(BinlogReadOnlyIncrementalSnapshotContext<U> context, Map<String, ?> offsets) {
        AbstractIncrementalSnapshotContext.init(context, offsets);
        Long signalOffset = (Long)offsets.get(SIGNAL_OFFSET);
        context.setSignalOffset(signalOffset);
        return context;
    }
}

