/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import io.dapr.durabletask.RetryHandler;
import io.dapr.durabletask.RetryPolicy;

public final class TaskOptions {
    private final RetryPolicy retryPolicy;
    private final RetryHandler retryHandler;
    private final String appID;

    private TaskOptions(RetryPolicy retryPolicy, RetryHandler retryHandler, String appID) {
        this.retryPolicy = retryPolicy;
        this.retryHandler = retryHandler;
        this.appID = appID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TaskOptions create() {
        return new Builder().build();
    }

    public static TaskOptions withRetryPolicy(RetryPolicy retryPolicy) {
        return new Builder().retryPolicy(retryPolicy).build();
    }

    public static TaskOptions withRetryHandler(RetryHandler retryHandler) {
        return new Builder().retryHandler(retryHandler).build();
    }

    public static TaskOptions withAppID(String appID) {
        return new Builder().appID(appID).build();
    }

    boolean hasRetryPolicy() {
        return this.retryPolicy != null;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    boolean hasRetryHandler() {
        return this.retryHandler != null;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public String getAppID() {
        return this.appID;
    }

    boolean hasAppID() {
        return this.appID != null && !this.appID.isEmpty();
    }

    public static final class Builder {
        private RetryPolicy retryPolicy;
        private RetryHandler retryHandler;
        private String appID;

        private Builder() {
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder retryHandler(RetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public Builder appID(String appID) {
            this.appID = appID;
            return this;
        }

        public TaskOptions build() {
            return new TaskOptions(this.retryPolicy, this.retryHandler, this.appID);
        }
    }
}

