/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import javax.annotation.Nullable;

final class Utils {
    private Utils() {
    }

    static void checkArgument(boolean isValid, @Nullable Object errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Utils.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static void checkState(boolean isValid, @Nullable Object errorMessage) {
        if (!isValid) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    static void checkIndex(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size: " + size);
        }
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index out of bounds: size=" + size + ", index=" + index);
        }
    }

    public static <T> T checkNotNull(T arg, @Nullable Object errorMessage) {
        if (arg == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return arg;
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        if (args == null) {
            return template;
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

