/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import io.dapr.internal.opencensus.BigendianEncoding;
import io.dapr.internal.opencensus.Utils;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TraceOptions {
    static final int SIZE = 1;
    private final byte options;

    private TraceOptions(byte options) {
        this.options = options;
    }

    static TraceOptions fromLowerBase16(CharSequence src, int srcOffset) {
        return new TraceOptions(BigendianEncoding.byteFromBase16String(src, srcOffset));
    }

    void copyBytesTo(byte[] dest, int destOffset) {
        Utils.checkIndex(destOffset, dest.length);
        dest[destOffset] = this.options;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceOptions)) {
            return false;
        }
        TraceOptions that = (TraceOptions)obj;
        return this.options == that.options;
    }

    public int hashCode() {
        return Arrays.hashCode(new byte[]{this.options});
    }
}

