/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public class DaprMetadataReceiverInterceptor
implements ClientInterceptor {
    private final Consumer<Metadata> metadataConsumer;

    public DaprMetadataReceiverInterceptor(Consumer<Metadata> metadataConsumer) {
        this.metadataConsumer = metadataConsumer;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall clientCall = channel.newCall(methodDescriptor, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(final ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener headerListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        responseListener.onHeaders(headers);
                        if (DaprMetadataReceiverInterceptor.this.metadataConsumer != null) {
                            DaprMetadataReceiverInterceptor.this.metadataConsumer.accept(headers);
                        }
                    }
                };
                super.start((ClientCall.Listener)headerListener, metadata);
            }
        };
    }
}

