/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.config;

import java.util.logging.Logger;

public abstract class Property<T> {
    private static final Logger LOGGER = Logger.getLogger(Property.class.getName());
    private final String name;
    private final String envName;
    private final T defaultValue;

    Property(String name, String envName, T defaultValue) {
        this.name = name;
        this.envName = envName;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getEnvName() {
        return this.envName;
    }

    public T get() {
        return this.get(null);
    }

    public T get(String override) {
        String envValue;
        String propValue;
        if (override != null && !override.isEmpty()) {
            try {
                return this.parse(override);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning(String.format("Invalid override value in property: %s", this.name));
            }
        }
        if ((propValue = System.getProperty(this.name)) != null && !propValue.trim().isEmpty()) {
            try {
                return this.parse(propValue);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning(String.format("Invalid value in property: %s", this.name));
            }
        }
        if ((envValue = System.getenv(this.envName)) != null && !envValue.trim().isEmpty()) {
            try {
                return this.parse(envValue);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning(String.format("Invalid value in environment variable: %s", this.envName));
            }
        }
        return this.defaultValue;
    }

    protected abstract T parse(String var1);
}

