/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.domain.ActorMetadata;
import io.dapr.client.domain.AppConnectionPropertiesMetadata;
import io.dapr.client.domain.ComponentMetadata;
import io.dapr.client.domain.HttpEndpointMetadata;
import io.dapr.client.domain.SubscriptionMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DaprMetadata {
    private final String id;
    private final String runtimeVersion;
    private final List<String> enabledFeatures;
    private final List<ActorMetadata> actors;
    private final Map<String, String> attributes;
    private final List<ComponentMetadata> components;
    private final List<HttpEndpointMetadata> httpEndpoints;
    private final List<SubscriptionMetadata> subscriptions;
    private final AppConnectionPropertiesMetadata appConnectionProperties;

    public DaprMetadata(String id, String runtimeVersion, List<String> enabledFeatures, List<ActorMetadata> actors, Map<String, String> attributes, List<ComponentMetadata> components, List<HttpEndpointMetadata> httpEndpoints, List<SubscriptionMetadata> subscriptions, AppConnectionPropertiesMetadata appConnectionProperties) {
        this.id = id;
        this.runtimeVersion = runtimeVersion;
        this.enabledFeatures = enabledFeatures == null ? Collections.emptyList() : Collections.unmodifiableList(enabledFeatures);
        this.actors = actors == null ? Collections.emptyList() : Collections.unmodifiableList(actors);
        this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        this.components = components == null ? Collections.emptyList() : Collections.unmodifiableList(components);
        this.httpEndpoints = httpEndpoints == null ? Collections.emptyList() : Collections.unmodifiableList(httpEndpoints);
        this.subscriptions = subscriptions == null ? Collections.emptyList() : Collections.unmodifiableList(subscriptions);
        this.appConnectionProperties = appConnectionProperties;
    }

    public String getId() {
        return this.id;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public List<String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public List<ActorMetadata> getActors() {
        return this.actors;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<ComponentMetadata> getComponents() {
        return this.components;
    }

    public List<HttpEndpointMetadata> getHttpEndpoints() {
        return this.httpEndpoints;
    }

    public List<SubscriptionMetadata> getSubscriptions() {
        return this.subscriptions;
    }

    public AppConnectionPropertiesMetadata getAppConnectionProperties() {
        return this.appConnectionProperties;
    }
}

