/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.config.Properties;
import io.dapr.durabletask.DurableTaskGrpcWorkerBuilder;
import io.dapr.utils.NetworkUtils;
import io.dapr.workflows.Workflow;
import io.dapr.workflows.WorkflowActivity;
import io.dapr.workflows.internal.ApiTokenClientInterceptor;
import io.dapr.workflows.runtime.WorkflowActivityClassWrapper;
import io.dapr.workflows.runtime.WorkflowActivityInstanceWrapper;
import io.dapr.workflows.runtime.WorkflowClassWrapper;
import io.dapr.workflows.runtime.WorkflowInstanceWrapper;
import io.dapr.workflows.runtime.WorkflowRuntime;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRuntimeBuilder {
    private ClientInterceptor workflowApiTokenInterceptor;
    private static volatile WorkflowRuntime instance;
    private final Logger logger;
    private final Set<String> workflows = new HashSet<String>();
    private final Set<String> activities = new HashSet<String>();
    private final Set<String> activitySet = Collections.synchronizedSet(new HashSet());
    private final Set<String> workflowSet = Collections.synchronizedSet(new HashSet());
    private final DurableTaskGrpcWorkerBuilder builder;
    private final ManagedChannel managedChannel;
    private ExecutorService executorService;

    public WorkflowRuntimeBuilder() {
        this(new Properties());
    }

    public WorkflowRuntimeBuilder(Properties properties) {
        this(properties, LoggerFactory.getLogger(WorkflowRuntimeBuilder.class));
    }

    public WorkflowRuntimeBuilder(Logger logger) {
        this(new Properties(), logger);
    }

    private WorkflowRuntimeBuilder(Properties properties, Logger logger) {
        this.workflowApiTokenInterceptor = new ApiTokenClientInterceptor(properties);
        this.managedChannel = NetworkUtils.buildGrpcManagedChannel((Properties)properties, (ClientInterceptor[])new ClientInterceptor[]{this.workflowApiTokenInterceptor});
        this.builder = new DurableTaskGrpcWorkerBuilder().grpcChannel((Channel)this.managedChannel);
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WorkflowRuntime build() {
        if (instance == null) {
            Class<WorkflowRuntime> clazz = WorkflowRuntime.class;
            // MONITORENTER : io.dapr.workflows.runtime.WorkflowRuntime.class
            ExecutorService executorService = this.executorService = this.executorService == null ? Executors.newCachedThreadPool() : this.executorService;
            if (instance == null) {
                instance = new WorkflowRuntime(this.builder.withExecutorService(this.executorService).build(), this.managedChannel, this.executorService);
            }
            // MONITOREXIT : clazz
        }
        this.logger.info("List of registered workflows: {}", this.workflowSet);
        this.logger.info("List of registered activities: {}", this.activitySet);
        this.logger.info("Successfully built dapr workflow runtime");
        return instance;
    }

    public WorkflowRuntimeBuilder withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.builder.withExecutorService(executorService);
        return this;
    }

    public <T extends Workflow> WorkflowRuntimeBuilder registerWorkflow(Class<T> clazz) {
        this.builder.addOrchestration(new WorkflowClassWrapper<T>(clazz));
        this.workflowSet.add(clazz.getCanonicalName());
        this.workflows.add(clazz.getSimpleName());
        this.logger.info("Registered Workflow: {}", (Object)clazz.getSimpleName());
        return this;
    }

    public <T extends Workflow> WorkflowRuntimeBuilder registerWorkflow(T instance) {
        Class<?> clazz = instance.getClass();
        this.builder.addOrchestration(new WorkflowInstanceWrapper<T>(instance));
        this.workflowSet.add(clazz.getCanonicalName());
        this.workflows.add(clazz.getSimpleName());
        this.logger.info("Registered Workflow: {}", (Object)clazz.getSimpleName());
        return this;
    }

    public <T extends WorkflowActivity> WorkflowRuntimeBuilder registerActivity(Class<T> clazz) {
        return this.registerActivity(clazz.getCanonicalName(), (T)((Object)clazz));
    }

    public <T extends WorkflowActivity> WorkflowRuntimeBuilder registerActivity(String name, Class<T> clazz) {
        this.builder.addActivity(new WorkflowActivityClassWrapper<T>(name, clazz));
        this.activitySet.add(name);
        this.activities.add(name);
        this.logger.info("Registered Activity: {}", (Object)clazz.getSimpleName());
        return this;
    }

    public <T extends WorkflowActivity> WorkflowRuntimeBuilder registerActivity(T instance) {
        return this.registerActivity(instance.getClass().getCanonicalName(), instance);
    }

    public <T extends WorkflowActivity> WorkflowRuntimeBuilder registerActivity(String name, T instance) {
        this.builder.addActivity(new WorkflowActivityInstanceWrapper<T>(name, instance));
        this.activitySet.add(name);
        this.activities.add(name);
        this.logger.info("Registered Activity: {}", (Object)name);
        return this;
    }
}

