/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.DurableTaskGrpcWorker;
import io.grpc.ManagedChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class WorkflowRuntime
implements AutoCloseable {
    private final DurableTaskGrpcWorker worker;
    private final ManagedChannel managedChannel;
    private final ExecutorService executorService;

    public WorkflowRuntime(DurableTaskGrpcWorker worker, ManagedChannel managedChannel, ExecutorService executorService) {
        this.worker = worker;
        this.managedChannel = managedChannel;
        this.executorService = executorService;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean block) {
        if (block) {
            this.worker.startAndBlock();
        } else {
            this.worker.start();
        }
    }

    @Override
    public void close() {
        this.shutDownWorkerPool();
        this.closeSideCarChannel();
    }

    private void closeSideCarChannel() {
        this.managedChannel.shutdown();
        try {
            if (!this.managedChannel.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.managedChannel.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void shutDownWorkerPool() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

