/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.TaskOrchestration;
import io.dapr.durabletask.TaskOrchestrationFactory;
import io.dapr.workflows.Workflow;
import io.dapr.workflows.runtime.DefaultWorkflowContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class WorkflowClassWrapper<T extends Workflow>
implements TaskOrchestrationFactory {
    private final Constructor<T> workflowConstructor;
    private final String name;

    public WorkflowClassWrapper(Class<T> clazz) {
        this.name = clazz.getCanonicalName();
        try {
            this.workflowConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("No constructor found for workflow class '%s'.", this.name), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public TaskOrchestration create() {
        return ctx -> {
            Workflow workflow;
            try {
                workflow = (Workflow)this.workflowConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Unable to instantiate instance of workflow class '%s'", this.name), e);
            }
            workflow.run(new DefaultWorkflowContext(ctx));
        };
    }
}

