/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.TaskActivity;
import io.dapr.durabletask.TaskActivityFactory;
import io.dapr.workflows.WorkflowActivity;
import io.dapr.workflows.runtime.DefaultWorkflowActivityContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class WorkflowActivityClassWrapper<T extends WorkflowActivity>
implements TaskActivityFactory {
    private final Constructor<T> activityConstructor;
    private final String name;

    public WorkflowActivityClassWrapper(String name, Class<T> clazz) {
        this.name = name;
        try {
            this.activityConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("No constructor found for activity class '%s'.", this.name), e);
        }
    }

    public WorkflowActivityClassWrapper(Class<T> clazz) {
        this(clazz.getCanonicalName(), clazz);
    }

    public String getName() {
        return this.name;
    }

    public TaskActivity create() {
        return ctx -> {
            WorkflowActivity activity;
            try {
                activity = (WorkflowActivity)this.activityConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Unable to instantiate instance of activity class '%s'", this.name), e);
            }
            Object result = activity.run(new DefaultWorkflowActivityContext(ctx));
            return result;
        };
    }
}

