/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.FailureDetails;
import io.dapr.durabletask.OrchestrationMetadata;
import io.dapr.durabletask.OrchestrationRuntimeStatus;
import io.dapr.workflows.client.WorkflowFailureDetails;
import io.dapr.workflows.client.WorkflowInstanceStatus;
import io.dapr.workflows.client.WorkflowRuntimeStatus;
import io.dapr.workflows.runtime.DefaultWorkflowFailureDetails;
import io.dapr.workflows.runtime.WorkflowRuntimeStatusConverter;
import java.time.Instant;
import javax.annotation.Nullable;

public class DefaultWorkflowInstanceStatus
implements WorkflowInstanceStatus {
    private final OrchestrationMetadata orchestrationMetadata;
    @Nullable
    private final WorkflowFailureDetails failureDetails;

    public DefaultWorkflowInstanceStatus(OrchestrationMetadata orchestrationMetadata) {
        if (orchestrationMetadata == null) {
            throw new IllegalArgumentException("OrchestrationMetadata cannot be null");
        }
        this.orchestrationMetadata = orchestrationMetadata;
        FailureDetails details = orchestrationMetadata.getFailureDetails();
        this.failureDetails = details != null ? new DefaultWorkflowFailureDetails(details) : null;
    }

    @Override
    public String getName() {
        return this.orchestrationMetadata.getName();
    }

    @Override
    public String getInstanceId() {
        return this.orchestrationMetadata.getInstanceId();
    }

    @Override
    public WorkflowRuntimeStatus getRuntimeStatus() {
        OrchestrationRuntimeStatus status = this.orchestrationMetadata.getRuntimeStatus();
        return WorkflowRuntimeStatusConverter.fromOrchestrationRuntimeStatus(status);
    }

    @Override
    public Instant getCreatedAt() {
        return this.orchestrationMetadata.getCreatedAt();
    }

    @Override
    public Instant getLastUpdatedAt() {
        return this.orchestrationMetadata.getLastUpdatedAt();
    }

    @Override
    public String getSerializedInput() {
        return this.orchestrationMetadata.getSerializedInput();
    }

    @Override
    public String getSerializedOutput() {
        return this.orchestrationMetadata.getSerializedOutput();
    }

    @Override
    @Nullable
    public WorkflowFailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    @Override
    public boolean isRunning() {
        return this.orchestrationMetadata.isRunning();
    }

    @Override
    public boolean isCompleted() {
        return this.orchestrationMetadata.isCompleted();
    }

    @Override
    public <T> T readInputAs(Class<T> type) {
        return (T)this.orchestrationMetadata.readInputAs(type);
    }

    @Override
    public <T> T readOutputAs(Class<T> type) {
        return (T)this.orchestrationMetadata.readOutputAs(type);
    }

    public String toString() {
        return this.orchestrationMetadata.toString();
    }
}

