/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.CompositeTaskFailedException;
import io.dapr.durabletask.RetryHandler;
import io.dapr.durabletask.RetryPolicy;
import io.dapr.durabletask.Task;
import io.dapr.durabletask.TaskCanceledException;
import io.dapr.durabletask.TaskOptions;
import io.dapr.durabletask.TaskOrchestrationContext;
import io.dapr.workflows.WorkflowContext;
import io.dapr.workflows.WorkflowTaskOptions;
import io.dapr.workflows.WorkflowTaskRetryContext;
import io.dapr.workflows.WorkflowTaskRetryHandler;
import io.dapr.workflows.WorkflowTaskRetryPolicy;
import io.dapr.workflows.runtime.DefaultWorkflowFailureDetails;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class DefaultWorkflowContext
implements WorkflowContext {
    private final TaskOrchestrationContext innerContext;
    private final Logger logger;

    public DefaultWorkflowContext(TaskOrchestrationContext context) throws IllegalArgumentException {
        this(context, LoggerFactory.getLogger(WorkflowContext.class));
    }

    public DefaultWorkflowContext(TaskOrchestrationContext context, Logger logger) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        this.innerContext = context;
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        if (this.innerContext.getIsReplaying()) {
            return NOPLogger.NOP_LOGGER;
        }
        return this.logger;
    }

    @Override
    public String getName() {
        return this.innerContext.getName();
    }

    @Override
    public String getInstanceId() {
        return this.innerContext.getInstanceId();
    }

    @Override
    public Instant getCurrentInstant() {
        return this.innerContext.getCurrentInstant();
    }

    @Override
    public void complete(Object output) {
        this.innerContext.complete(output);
    }

    @Override
    public <V> Task<V> waitForExternalEvent(String name, Duration timeout, Class<V> dataType) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, timeout, dataType);
    }

    @Override
    public Task<Void> waitForExternalEvent(String name, Duration timeout) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, timeout, Void.class);
    }

    @Override
    public Task<Void> waitForExternalEvent(String name) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, null, Void.class);
    }

    @Override
    public boolean isReplaying() {
        return this.innerContext.getIsReplaying();
    }

    @Override
    public <V> Task<V> callActivity(String name, Object input, WorkflowTaskOptions options, Class<V> returnType) {
        TaskOptions taskOptions = this.toTaskOptions(options);
        return this.innerContext.callActivity(name, input, taskOptions, returnType);
    }

    @Override
    public <V> Task<List<V>> allOf(List<Task<V>> tasks) throws CompositeTaskFailedException {
        return this.innerContext.allOf(tasks);
    }

    @Override
    public Task<Task<?>> anyOf(List<Task<?>> tasks) {
        return this.innerContext.anyOf(tasks);
    }

    @Override
    public Task<Void> createTimer(Duration duration) {
        return this.innerContext.createTimer(duration);
    }

    @Override
    public Task<Void> createTimer(ZonedDateTime zonedDateTime) {
        return this.innerContext.createTimer(zonedDateTime);
    }

    public <T> T getInput(Class<T> targetType) {
        return (T)this.innerContext.getInput(targetType);
    }

    @Override
    public <V> Task<V> callChildWorkflow(String name, @Nullable Object input, @Nullable String instanceID, @Nullable WorkflowTaskOptions options, Class<V> returnType) {
        TaskOptions taskOptions = this.toTaskOptions(options);
        return this.innerContext.callSubOrchestrator(name, input, instanceID, taskOptions, returnType);
    }

    @Override
    public void continueAsNew(Object input) {
        this.innerContext.continueAsNew(input);
    }

    @Override
    public void continueAsNew(Object input, boolean preserveUnprocessedEvents) {
        this.innerContext.continueAsNew(input, preserveUnprocessedEvents);
    }

    @Override
    public UUID newUuid() {
        return this.innerContext.newUUID();
    }

    private TaskOptions toTaskOptions(WorkflowTaskOptions options) {
        if (options == null) {
            return null;
        }
        RetryPolicy retryPolicy = this.toRetryPolicy(options.getRetryPolicy());
        RetryHandler retryHandler = this.toRetryHandler(options.getRetryHandler());
        return TaskOptions.builder().retryPolicy(retryPolicy).retryHandler(retryHandler).appID(options.getAppId()).build();
    }

    private RetryPolicy toRetryPolicy(WorkflowTaskRetryPolicy workflowTaskRetryPolicy) {
        if (workflowTaskRetryPolicy == null) {
            return null;
        }
        RetryPolicy retryPolicy = new RetryPolicy(workflowTaskRetryPolicy.getMaxNumberOfAttempts(), workflowTaskRetryPolicy.getFirstRetryInterval());
        retryPolicy.setBackoffCoefficient(workflowTaskRetryPolicy.getBackoffCoefficient());
        if (workflowTaskRetryPolicy.getRetryTimeout() != null) {
            retryPolicy.setRetryTimeout(workflowTaskRetryPolicy.getRetryTimeout());
        }
        return retryPolicy;
    }

    private RetryHandler toRetryHandler(WorkflowTaskRetryHandler workflowTaskRetryHandler) {
        if (workflowTaskRetryHandler == null) {
            return null;
        }
        return retryContext -> {
            WorkflowTaskRetryContext workflowRetryContext = new WorkflowTaskRetryContext(this, retryContext.getLastAttemptNumber(), new DefaultWorkflowFailureDetails(retryContext.getLastFailure()), retryContext.getTotalRetryTime());
            return workflowTaskRetryHandler.handle(workflowRetryContext);
        };
    }

    @Override
    public void setCustomStatus(Object status) {
        this.innerContext.setCustomStatus(status);
    }
}

