/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.internal;

import io.dapr.config.Properties;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class ApiTokenClientInterceptor
implements ClientInterceptor {
    private Properties properties;

    public ApiTokenClientInterceptor(Properties properties) {
        this.properties = properties;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options, Channel channel) {
        ClientCall clientCall = channel.newCall(methodDescriptor, options);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                String daprApiToken = (String)ApiTokenClientInterceptor.this.properties.getValue(Properties.API_TOKEN);
                if (daprApiToken != null) {
                    metadata.put(Metadata.Key.of((String)"dapr-api-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)daprApiToken);
                }
                super.start(responseListener, metadata);
            }
        };
    }
}

