/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.client;

import io.dapr.config.Properties;
import io.dapr.durabletask.DurableTaskClient;
import io.dapr.durabletask.DurableTaskGrpcClientBuilder;
import io.dapr.durabletask.NewOrchestrationInstanceOptions;
import io.dapr.durabletask.OrchestrationMetadata;
import io.dapr.durabletask.PurgeResult;
import io.dapr.utils.NetworkUtils;
import io.dapr.workflows.Workflow;
import io.dapr.workflows.client.NewWorkflowOptions;
import io.dapr.workflows.client.WorkflowInstanceStatus;
import io.dapr.workflows.internal.ApiTokenClientInterceptor;
import io.dapr.workflows.runtime.DefaultWorkflowInstanceStatus;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class DaprWorkflowClient
implements AutoCloseable {
    private ClientInterceptor workflowApiTokenInterceptor;
    private DurableTaskClient innerClient;
    private ManagedChannel grpcChannel;

    public DaprWorkflowClient() {
        this(new Properties());
    }

    public DaprWorkflowClient(Properties properties) {
        this(NetworkUtils.buildGrpcManagedChannel((Properties)properties, (ClientInterceptor[])new ClientInterceptor[]{new ApiTokenClientInterceptor(properties)}));
    }

    private DaprWorkflowClient(ManagedChannel grpcChannel) {
        this(DaprWorkflowClient.createDurableTaskClient(grpcChannel), grpcChannel);
    }

    private DaprWorkflowClient(DurableTaskClient innerClient, ManagedChannel grpcChannel) {
        this.innerClient = innerClient;
        this.grpcChannel = grpcChannel;
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName());
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, Object input) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), input);
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, Object input, String instanceId) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), input, instanceId);
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, NewWorkflowOptions options) {
        NewOrchestrationInstanceOptions orchestrationInstanceOptions = DaprWorkflowClient.fromNewWorkflowOptions(options);
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), orchestrationInstanceOptions);
    }

    public void suspendWorkflow(String workflowInstanceId, @Nullable String reason) {
        this.innerClient.suspendInstance(workflowInstanceId, reason);
    }

    public void resumeWorkflow(String workflowInstanceId, @Nullable String reason) {
        this.innerClient.resumeInstance(workflowInstanceId, reason);
    }

    public void terminateWorkflow(String workflowInstanceId, @Nullable Object output) {
        this.innerClient.terminate(workflowInstanceId, output);
    }

    @Nullable
    public WorkflowInstanceStatus getInstanceState(String instanceId, boolean getInputsAndOutputs) {
        OrchestrationMetadata metadata = this.innerClient.getInstanceMetadata(instanceId, getInputsAndOutputs);
        return metadata == null ? null : new DefaultWorkflowInstanceStatus(metadata);
    }

    @Nullable
    public WorkflowInstanceStatus waitForInstanceStart(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestrationMetadata metadata = this.innerClient.waitForInstanceStart(instanceId, timeout, getInputsAndOutputs);
        return metadata == null ? null : new DefaultWorkflowInstanceStatus(metadata);
    }

    @Nullable
    public WorkflowInstanceStatus waitForInstanceCompletion(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestrationMetadata metadata = this.innerClient.waitForInstanceCompletion(instanceId, timeout, getInputsAndOutputs);
        return metadata == null ? null : new DefaultWorkflowInstanceStatus(metadata);
    }

    public void raiseEvent(String workflowInstanceId, String eventName, Object eventPayload) {
        this.innerClient.raiseEvent(workflowInstanceId, eventName, eventPayload);
    }

    public boolean purgeInstance(String workflowInstanceId) {
        PurgeResult result = this.innerClient.purgeInstance(workflowInstanceId);
        if (result != null) {
            return result.getDeletedInstanceCount() > 0;
        }
        return false;
    }

    @Override
    public void close() throws InterruptedException {
        try {
            if (this.innerClient != null) {
                this.innerClient.close();
                this.innerClient = null;
            }
        }
        finally {
            if (this.grpcChannel != null && !this.grpcChannel.isShutdown()) {
                this.grpcChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                this.grpcChannel = null;
            }
        }
    }

    private static DurableTaskClient createDurableTaskClient(ManagedChannel grpcChannel) {
        return new DurableTaskGrpcClientBuilder().grpcChannel((Channel)grpcChannel).build();
    }

    private static NewOrchestrationInstanceOptions fromNewWorkflowOptions(NewWorkflowOptions options) {
        NewOrchestrationInstanceOptions instanceOptions = new NewOrchestrationInstanceOptions();
        if (options.getVersion() != null) {
            instanceOptions.setVersion(options.getVersion());
        }
        if (options.getInstanceId() != null) {
            instanceOptions.setInstanceId(options.getInstanceId());
        }
        if (options.getInput() != null) {
            instanceOptions.setInput(options.getInput());
        }
        if (options.getStartTime() != null) {
            instanceOptions.setStartTime(options.getStartTime());
        }
        return instanceOptions;
    }
}

