/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows;

import java.time.Duration;
import javax.annotation.Nullable;

public final class WorkflowTaskRetryPolicy {
    private final Integer maxNumberOfAttempts;
    private final Duration firstRetryInterval;
    private final Double backoffCoefficient;
    private final Duration maxRetryInterval;
    private final Duration retryTimeout;

    public WorkflowTaskRetryPolicy(Integer maxNumberOfAttempts, Duration firstRetryInterval, Double backoffCoefficient, Duration maxRetryInterval, Duration retryTimeout) {
        this.maxNumberOfAttempts = maxNumberOfAttempts;
        this.firstRetryInterval = firstRetryInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.maxRetryInterval = maxRetryInterval;
        this.retryTimeout = retryTimeout;
    }

    public int getMaxNumberOfAttempts() {
        return this.maxNumberOfAttempts;
    }

    public Duration getFirstRetryInterval() {
        return this.firstRetryInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public Duration getRetryTimeout() {
        return this.retryTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer maxNumberOfAttempts;
        private Duration firstRetryInterval;
        private Double backoffCoefficient = 1.0;
        private Duration maxRetryInterval;
        private Duration retryTimeout;

        private Builder() {
        }

        public WorkflowTaskRetryPolicy build() {
            return new WorkflowTaskRetryPolicy(this.maxNumberOfAttempts, this.firstRetryInterval, this.backoffCoefficient, this.maxRetryInterval, this.retryTimeout);
        }

        public Builder setMaxNumberOfAttempts(int maxNumberOfAttempts) {
            if (maxNumberOfAttempts <= 0) {
                throw new IllegalArgumentException("The value for maxNumberOfAttempts must be greater than zero.");
            }
            this.maxNumberOfAttempts = maxNumberOfAttempts;
            return this;
        }

        public Builder setFirstRetryInterval(Duration firstRetryInterval) {
            if (firstRetryInterval == null) {
                throw new IllegalArgumentException("firstRetryInterval cannot be null.");
            }
            if (firstRetryInterval.isZero() || firstRetryInterval.isNegative()) {
                throw new IllegalArgumentException("The value for firstRetryInterval must be greater than zero.");
            }
            this.firstRetryInterval = firstRetryInterval;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient < 1.0) {
                throw new IllegalArgumentException("The value for backoffCoefficient must be greater or equal to 1.0.");
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaxRetryInterval(@Nullable Duration maxRetryInterval) {
            if (maxRetryInterval != null && maxRetryInterval.compareTo(this.firstRetryInterval) < 0) {
                throw new IllegalArgumentException("The value for maxRetryInterval must be greater than or equal to the value for firstRetryInterval.");
            }
            this.maxRetryInterval = maxRetryInterval;
            return this;
        }

        public Builder setRetryTimeout(Duration retryTimeout) {
            if (retryTimeout == null || retryTimeout.compareTo(this.firstRetryInterval) < 0) {
                throw new IllegalArgumentException("The value for retryTimeout cannot be null and must be greater than or equal to the value for firstRetryInterval.");
            }
            this.retryTimeout = retryTimeout;
            return this;
        }
    }
}

