/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testngxmlformatter;

import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.testngxmlformatter.EscapingXmlStreamWriter;
import io.cucumber.testngxmlformatter.XmlReportData;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

class XmlReportWriter {
    private final XmlReportData data;

    XmlReportWriter(XmlReportData data) {
        this.data = data;
    }

    void writeXmlReport(Writer out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        EscapingXmlStreamWriter writer = new EscapingXmlStreamWriter(factory.createXMLStreamWriter(out));
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeNewLine();
        this.writeTestngResults(writer);
        writer.writeEndDocument();
        writer.flush();
    }

    private void writeTestngResults(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("testng-results");
        this.writeTestngResultsAttributes(writer);
        writer.writeNewLine();
        this.writeSuite(writer);
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private void writeTestngResultsAttributes(EscapingXmlStreamWriter writer) throws XMLStreamException {
        Map<TestStepResultStatus, Long> counts = this.data.getTestCaseStatusCounts();
        writer.writeAttribute("failed", String.valueOf(XmlReportWriter.countFailures(counts)));
        writer.writeAttribute("passed", counts.getOrDefault(TestStepResultStatus.PASSED, 0L).toString());
        writer.writeAttribute("skipped", counts.getOrDefault(TestStepResultStatus.SKIPPED, 0L).toString());
        writer.writeAttribute("total", String.valueOf(this.data.getTestCaseCount()));
    }

    private static long countFailures(Map<TestStepResultStatus, Long> counts) {
        return XmlReportWriter.createNotPassedNotSkippedSet().stream().mapToLong(s -> counts.getOrDefault(s, 0L)).sum();
    }

    private static EnumSet<TestStepResultStatus> createNotPassedNotSkippedSet() {
        EnumSet<TestStepResultStatus> notPassedNotSkipped = EnumSet.allOf(TestStepResultStatus.class);
        notPassedNotSkipped.remove(TestStepResultStatus.PASSED);
        notPassedNotSkipped.remove(TestStepResultStatus.SKIPPED);
        return notPassedNotSkipped;
    }

    private void writeSuite(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("suite");
        this.writeSuiteAttributes(writer);
        writer.writeNewLine();
        this.writeTest(writer);
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private void writeSuiteAttributes(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("name", "Cucumber");
        writer.writeAttribute("duration-ms", String.valueOf(this.data.getSuiteDurationInMilliSeconds()));
    }

    private void writeTest(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("test");
        this.writeTestAttributes(writer);
        writer.writeNewLine();
        for (Map.Entry<Optional<Feature>, List<TestCaseStarted>> entry : this.data.getAllTestCaseStartedGroupedByFeature()) {
            writer.writeStartElement("class");
            String featureName = entry.getKey().map(Feature::getName).orElse("Unknown");
            writer.writeAttribute("name", featureName);
            writer.writeNewLine();
            for (TestCaseStarted testCaseStarted : entry.getValue()) {
                this.writeTestMethod(writer, testCaseStarted);
            }
            writer.writeEndElement();
            writer.writeNewLine();
        }
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private void writeTestAttributes(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("name", "Cucumber");
        writer.writeAttribute("duration-ms", String.valueOf(this.data.getSuiteDurationInMilliSeconds()));
    }

    private void writeTestMethod(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        TestStepResult result = this.data.getTestCaseStatus(testCaseStarted);
        boolean passing = XmlReportWriter.isPassed(result);
        if (passing) {
            writer.writeEmptyElement("test-method");
        } else {
            writer.writeStartElement("test-method");
        }
        this.writeTestMethodAttributes(writer, testCaseStarted, result);
        if (!passing) {
            writer.writeNewLine();
            this.writeException(writer, testCaseStarted, result);
            writer.writeEndElement();
        }
        writer.writeNewLine();
    }

    private static boolean isPassed(TestStepResult result) {
        TestStepResultStatus status = result.getStatus();
        return status == TestStepResultStatus.PASSED;
    }

    private void writeTestMethodAttributes(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted, TestStepResult result) throws XMLStreamException {
        writer.writeAttribute("name", this.data.getPickleName(testCaseStarted));
        writer.writeAttribute("status", this.writeStatus(result));
        writer.writeAttribute("duration-ms", String.valueOf(this.data.getDurationInMilliSeconds(testCaseStarted)));
        writer.writeAttribute("started-at", this.data.getStartedAt(testCaseStarted));
        writer.writeAttribute("finished-at", this.data.getFinishedAt(testCaseStarted));
    }

    private String writeStatus(TestStepResult status) {
        switch (status.getStatus()) {
            case PASSED: {
                return "PASS";
            }
            case SKIPPED: {
                return "SKIP";
            }
        }
        return "FAIL";
    }

    private void writeException(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted, TestStepResult result) throws XMLStreamException {
        Exception exceptionOrSkippedOrUndefined = result.getException().orElseGet(XmlReportWriter.undefinedOrSkippedException(result.getStatus()));
        Optional stackTrace = exceptionOrSkippedOrUndefined.getStackTrace();
        writer.writeStartElement("exception");
        this.writeExceptionAttributes(writer, exceptionOrSkippedOrUndefined);
        writer.writeNewLine();
        this.writeMessage(writer, testCaseStarted);
        if (stackTrace.isPresent()) {
            writer.writeStartElement("full-stacktrace");
            writer.writeNewLine();
            writer.writeCData((String)stackTrace.get());
            writer.writeNewLine();
            writer.writeEndElement();
            writer.writeNewLine();
        }
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private static Supplier<Exception> undefinedOrSkippedException(TestStepResultStatus status) {
        if (status == TestStepResultStatus.SKIPPED) {
            return () -> new Exception("The scenario has skipped step(s)", null, "The scenario has skipped step(s)");
        }
        return () -> new Exception("The scenario has undefined step(s)", null, "The scenario has undefined step(s)");
    }

    private void writeExceptionAttributes(EscapingXmlStreamWriter writer, Exception exception) throws XMLStreamException {
        writer.writeAttribute("class", exception.getType());
    }

    private void writeMessage(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        List<Map.Entry<String, String>> results = this.data.getStepsAndResult(testCaseStarted);
        if (results.isEmpty()) {
            return;
        }
        writer.writeStartElement("message");
        writer.writeCData(this.createStepResultList(results));
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private String createStepResultList(List<Map.Entry<String, String>> results) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        results.forEach(r -> {
            String stepText = (String)r.getKey();
            String status = (String)r.getValue();
            sb.append(stepText);
            sb.append(".");
            for (int i = 75 - stepText.length(); i > 0; --i) {
                sb.append(".");
            }
            sb.append(status);
            sb.append("\n");
        });
        return sb.toString();
    }
}

