/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.query.GherkinDocumentElements;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class NamingStrategy {
    public static Builder strategy(Strategy strategy) {
        return new Builder(strategy);
    }

    private NamingStrategy() {
    }

    abstract String name(GherkinDocumentElements var1, Pickle var2);

    private static String exampleNumber(GherkinDocumentElements elements, Integer index) {
        String examplesPrefix = elements.examplesIndex().map(examplesIndex -> examplesIndex + 1).map(examplesIndex -> examplesIndex + ".").orElse("");
        return "Example #" + examplesPrefix + (index + 1);
    }

    private static String join(List<String> pieces) {
        return pieces.stream().filter(s -> !s.isEmpty()).collect(Collectors.joining(" - "));
    }

    public static class Builder {
        private final Strategy strategy;
        private FeatureName featureName = FeatureName.INCLUDE;
        private ExampleName exampleName = ExampleName.NUMBER;

        public Builder(Strategy strategy) {
            this.strategy = strategy;
        }

        public Builder exampleName(ExampleName exampleName) {
            this.exampleName = exampleName;
            return this;
        }

        public Builder featureName(FeatureName featureName) {
            this.featureName = featureName;
            return this;
        }

        public NamingStrategy build() {
            if (this.strategy == Strategy.SHORT) {
                return new ShortNamingStrategy(this.exampleName);
            }
            return new LongNamingStrategy(this.featureName, this.exampleName);
        }
    }

    private static class LongNamingStrategy
    extends NamingStrategy {
        private final FeatureName featureName;
        private final ExampleName exampleName;

        private LongNamingStrategy(FeatureName featureName, ExampleName exampleName) {
            this.featureName = featureName;
            this.exampleName = exampleName;
        }

        @Override
        String name(GherkinDocumentElements elements, Pickle pickle) {
            ArrayList pieces = new ArrayList();
            elements.feature().map(Feature::getName).filter(feature -> this.featureName == FeatureName.INCLUDE).ifPresent(pieces::add);
            elements.rule().map(Rule::getName).ifPresent(pieces::add);
            elements.scenario().map(Scenario::getName).ifPresent(pieces::add);
            elements.examples().map(Examples::getName).ifPresent(pieces::add);
            elements.exampleIndex().map(index -> this.exampleName == ExampleName.NUMBER ? NamingStrategy.exampleNumber(elements, index) : pickle.getName()).ifPresent(pieces::add);
            return NamingStrategy.join(pieces);
        }
    }

    private static class ShortNamingStrategy
    extends NamingStrategy {
        private final ExampleName exampleName;

        private ShortNamingStrategy(ExampleName exampleName) {
            this.exampleName = exampleName;
        }

        @Override
        String name(GherkinDocumentElements elements, Pickle pickle) {
            return elements.exampleIndex().filter(index -> this.exampleName == ExampleName.NUMBER).map(index -> NamingStrategy.exampleNumber(elements, index)).orElseGet(() -> ((Pickle)pickle).getName());
        }
    }

    public static enum FeatureName {
        INCLUDE,
        EXCLUDE;

    }

    public static enum ExampleName {
        NUMBER,
        PICKLE;

    }

    public static enum Strategy {
        LONG,
        SHORT;

    }
}

