/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.HookType;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Snippet;
import io.cucumber.messages.types.Suggestion;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunHookFinished;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.UndefinedParameterType;
import io.cucumber.prettyformatter.ExceptionFormatter;
import io.cucumber.prettyformatter.OrderableMessage;
import io.cucumber.prettyformatter.SourceReferenceFormatter;
import io.cucumber.prettyformatter.Theme;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SummaryReportWriter
implements AutoCloseable {
    private final Theme theme;
    private final Function<String, String> uriFormatter;
    private final SourceReferenceFormatter sourceReferenceFormatter;
    private final Query query;
    private final PrintWriter out;
    private final List<UndefinedParameterType> undefinedParameterTypes;

    SummaryReportWriter(OutputStream out, Theme theme, Function<String, String> uriFormatter, Repository data, List<UndefinedParameterType> undefinedParameterTypes) {
        this.theme = Objects.requireNonNull(theme);
        this.out = SummaryReportWriter.createPrintWriter(Objects.requireNonNull(out));
        this.uriFormatter = Objects.requireNonNull(uriFormatter);
        this.sourceReferenceFormatter = new SourceReferenceFormatter(uriFormatter);
        this.query = new Query(Objects.requireNonNull(data));
        this.undefinedParameterTypes = Objects.requireNonNull(undefinedParameterTypes);
    }

    private static PrintWriter createPrintWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        this.out.close();
    }

    public void printSummary() {
        this.printNonPassingScenarios();
        this.printUnknownParameterTypes();
        this.printNonPassingGlobalHooks();
        this.printNonPassingTestRun();
        this.printStats();
        this.printSnippets();
    }

    private void printStats() {
        this.out.println();
        this.printTestRunCount();
        this.printGlobalHookCount();
        this.printScenarioCounts();
        this.printStepCounts();
        this.printDuration();
    }

    private void printNonPassingGlobalHooks() {
        Map testRunHookFinishedByStatus = this.query.findAllTestRunHookFinished().stream().collect(Collectors.groupingBy(SummaryReportWriter::getTestStepResultStatusBy));
        EnumSet<TestStepResultStatus> excluded = EnumSet.of(TestStepResultStatus.PASSED, TestStepResultStatus.SKIPPED);
        for (TestStepResultStatus status : EnumSet.complementOf(excluded)) {
            this.printFinishedItemByStatus("hooks", testRunHookFinishedByStatus, status, this::formatHookLine, testRunHookFinished -> Optional.of(testRunHookFinished.getResult()));
        }
    }

    private void printNonPassingScenarios() {
        Map testCaseFinishedByStatus = this.findAllTestCasesFinishedInCanonicalOrder().collect(Collectors.groupingBy(this::getTestStepResultStatusBy));
        EnumSet<TestStepResultStatus> excluded = EnumSet.of(TestStepResultStatus.PASSED, TestStepResultStatus.SKIPPED);
        for (TestStepResultStatus status : EnumSet.complementOf(excluded)) {
            this.printFinishedItemByStatus("scenarios", testCaseFinishedByStatus, status, this::formatScenarioLine, arg_0 -> ((Query)this.query).findMostSevereTestStepResultBy(arg_0));
        }
    }

    private Stream<TestCaseFinished> findAllTestCasesFinishedInCanonicalOrder() {
        return this.query.findAllTestCaseFinished().stream().map(testCaseStarted -> {
            Optional pickle = this.query.findPickleBy(testCaseStarted);
            String uri = pickle.map(Pickle::getUri).orElse(null);
            Long line = pickle.flatMap(arg_0 -> ((Query)this.query).findLocationOf(arg_0)).map(Location::getLine).orElse(null);
            return new OrderableMessage<TestCaseFinished>((TestCaseFinished)testCaseStarted, uri, line);
        }).sorted().map(OrderableMessage::getMessage);
    }

    private Optional<String> formatScenarioLine(TestCaseFinished testCaseFinished) {
        return this.query.findTestCaseStartedBy(testCaseFinished).flatMap(testCaseStarted -> this.query.findPickleBy(testCaseStarted).map(pickle -> {
            String name = pickle.getName();
            String attempt = SummaryReportWriter.formatAttempt(testCaseStarted);
            String location = this.formatLocationComment((Pickle)pickle);
            return String.format("%s%s%s", name, attempt, location);
        }));
    }

    private Optional<String> formatHookLine(TestRunHookFinished testRunHookFinished) {
        return this.query.findHookBy(testRunHookFinished).map(hook -> {
            String hookTypeName = hook.getType().map(SummaryReportWriter::formatGlobalHookName).orElse("Unknown");
            String hookName = hook.getName().map(name -> "(" + name + ")").orElse("");
            String location = this.formatLocationComment((Hook)hook);
            return String.format("%s%s%s", hookTypeName, hookName, location);
        });
    }

    private static String formatGlobalHookName(HookType hookType) {
        switch (hookType) {
            case BEFORE_TEST_RUN: {
                return "BeforeTestRun";
            }
            case AFTER_TEST_RUN: {
                return "AfterTestRun";
            }
        }
        return "Unknown";
    }

    private <T> void printFinishedItemByStatus(String finishedItemName, Map<TestStepResultStatus, List<T>> finishedItemByStatus, TestStepResultStatus status, Function<T, Optional<String>> formatFinishedItem, Function<T, Optional<TestStepResult>> getTestStepResult) {
        List items = finishedItemByStatus.getOrDefault(status, Collections.emptyList());
        if (items.isEmpty()) {
            return;
        }
        this.out.println();
        String finishItemByStatusTitle = String.format("%s %s:", this.firstLetterCapitalizedName(status), finishedItemName);
        this.out.println(this.theme.style(Theme.Element.STEP, status, finishItemByStatusTitle));
        ExceptionFormatter formatter = new ExceptionFormatter(7, this.theme, status);
        AtomicInteger index = new AtomicInteger(0);
        for (Object testCaseFinished : items) {
            formatFinishedItem.apply(testCaseFinished).map(line -> String.format("  %d) %s", index.incrementAndGet(), line)).ifPresent(this.out::println);
            getTestStepResult.apply(testCaseFinished).flatMap(TestStepResult::getException).flatMap(formatter::format).ifPresent(this.out::println);
        }
    }

    private static String formatAttempt(TestCaseStarted testCaseStarted) {
        Long attempt = testCaseStarted.getAttempt();
        if (attempt == 0L) {
            return "";
        }
        return ", after " + attempt + " attempts";
    }

    private String formatLocationComment(Pickle pickle) {
        String formattedUri = this.uriFormatter.apply(pickle.getUri());
        String comment = "# " + formattedUri + this.query.findLocationOf(pickle).map(Location::getLine).map(line -> ":" + line).orElse("");
        return " " + this.theme.style(Theme.Element.LOCATION, comment);
    }

    private String formatLocationComment(Hook hook) {
        return this.sourceReferenceFormatter.format(hook.getSourceReference()).map(comment -> this.theme.style(Theme.Element.LOCATION, "#" + comment)).map(comment -> " " + comment).orElse("");
    }

    private void printNonPassingTestRun() {
        this.findTestRunWithException().ifPresent(exception -> {
            this.out.println(this.theme.style(Theme.Element.STEP, TestStepResultStatus.FAILED, this.firstLetterCapitalizedName(TestStepResultStatus.FAILED) + " test run:"));
            ExceptionFormatter formatter = new ExceptionFormatter(7, this.theme, TestStepResultStatus.FAILED);
            this.out.println(formatter.format((Exception)exception));
        });
    }

    private Optional<Exception> findTestRunWithException() {
        return this.query.findTestRunFinished().filter(testRunFinished -> testRunFinished.getSuccess() == false).flatMap(TestRunFinished::getException);
    }

    private void printTestRunCount() {
        this.findTestRunWithException().map(exception -> {
            String subCounts = this.theme.style(Theme.Element.STEP, TestStepResultStatus.FAILED, "1 failed");
            return "1 test run (" + subCounts + ")";
        }).ifPresent(this.out::println);
    }

    private void printGlobalHookCount() {
        List testRunHooksFinished = this.query.findAllTestRunHookFinished();
        if (testRunHooksFinished.isEmpty()) {
            return;
        }
        this.out.println(this.formatSubCounts("hooks", testRunHooksFinished, this.countTestStepResultStatusByTestRunHookFinished()));
    }

    private void printScenarioCounts() {
        this.out.println(this.formatSubCounts("scenarios", this.query.findAllTestCaseFinished(), this.countTestStepResultStatusByTestCaseFinished()));
    }

    private void printStepCounts() {
        this.out.println(this.formatSubCounts("steps", this.query.findAllTestCaseFinished().stream().map(arg_0 -> ((Query)this.query).findTestStepsFinishedBy(arg_0)).flatMap(Collection::stream).collect(Collectors.toList()), SummaryReportWriter.countTestStepResultStatusByTestStepFinished()));
    }

    private <T> String formatSubCounts(String itemName, Collection<T> finishedItems, Collector<T, ?, Map<TestStepResultStatus, Long>> countTestStepResultStatusByItem) {
        String countAndName = finishedItems.size() + " " + itemName;
        StringJoiner joiner = new StringJoiner(", ", countAndName + " (", ")");
        joiner.setEmptyValue(countAndName);
        Map<TestStepResultStatus, Long> subCounts = finishedItems.stream().collect(countTestStepResultStatusByItem);
        for (TestStepResultStatus status : TestStepResultStatus.values()) {
            long count = subCounts.getOrDefault(status, 0L);
            if (count == 0L) continue;
            joiner.add(this.theme.style(Theme.Element.STEP, status, count + " " + status.name().toLowerCase(Locale.ROOT)));
        }
        return joiner.toString();
    }

    private void printDuration() {
        this.query.findTestRunDuration().map(SummaryReportWriter::formatDuration).ifPresent(this.out::println);
    }

    private static String formatDuration(Duration duration) {
        long minutes = duration.toMinutes();
        long seconds = duration.minusMinutes(minutes).getSeconds();
        long milliseconds = TimeUnit.NANOSECONDS.toMillis(duration.getNano());
        return String.format("%sm %s.%ss", minutes, seconds, milliseconds);
    }

    private void printUnknownParameterTypes() {
        if (this.undefinedParameterTypes.isEmpty()) {
            return;
        }
        this.out.println();
        this.out.println(this.theme.style(Theme.Element.STEP, TestStepResultStatus.UNDEFINED, "These parameters are missing a parameter type definition:"));
        int index = 0;
        for (UndefinedParameterType undefinedParameterType : this.undefinedParameterTypes) {
            String name = undefinedParameterType.getName();
            String expression = undefinedParameterType.getExpression();
            this.out.println(String.format("  %s) '%s' in '%s'", ++index, name, expression));
        }
    }

    private void printSnippets() {
        Set snippets = this.findAllTestCasesFinishedInCanonicalOrder().map(arg_0 -> ((Query)this.query).findPickleBy(arg_0)).filter(Optional::isPresent).map(Optional::get).map(arg_0 -> ((Query)this.query).findSuggestionsBy(arg_0)).flatMap(Collection::stream).map(Suggestion::getSnippets).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        if (snippets.isEmpty()) {
            return;
        }
        this.out.println();
        this.out.println("You can implement missing steps with the snippets below:");
        this.out.println();
        for (Snippet snippet : snippets) {
            this.out.println(snippet.getCode());
            this.out.println();
        }
    }

    private Collector<TestRunHookFinished, ?, Map<TestStepResultStatus, Long>> countTestStepResultStatusByTestRunHookFinished() {
        return Collectors.groupingBy(SummaryReportWriter::getTestStepResultStatusBy, Collectors.counting());
    }

    private static TestStepResultStatus getTestStepResultStatusBy(TestRunHookFinished testRunHookFinished) {
        return testRunHookFinished.getResult().getStatus();
    }

    private Collector<TestCaseFinished, ?, Map<TestStepResultStatus, Long>> countTestStepResultStatusByTestCaseFinished() {
        return Collectors.groupingBy(this::getTestStepResultStatusBy, Collectors.counting());
    }

    private TestStepResultStatus getTestStepResultStatusBy(TestCaseFinished testCaseFinished) {
        return this.query.findMostSevereTestStepResultBy(testCaseFinished).map(TestStepResult::getStatus).orElse(TestStepResultStatus.PASSED);
    }

    private static Collector<TestStepFinished, ?, Map<TestStepResultStatus, Long>> countTestStepResultStatusByTestStepFinished() {
        return Collectors.groupingBy(SummaryReportWriter::getTestStepResultStatusBy, Collectors.counting());
    }

    private static TestStepResultStatus getTestStepResultStatusBy(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus();
    }

    private String firstLetterCapitalizedName(TestStepResultStatus status) {
        String name = status.name();
        return name.charAt(0) + name.substring(1).toLowerCase(Locale.ROOT);
    }
}

