/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.SourceReference;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.prettyformatter.MessagesToPrettyWriter;
import io.cucumber.query.Lineage;
import io.cucumber.query.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class PrettyReportData {
    private final Query query = new Query();
    private final Map<String, Integer> commentStartIndexByTestCaseStartedId = new HashMap<String, Integer>();
    private final Map<String, Integer> scenarioIndentByTestCaseStartedId = new HashMap<String, Integer>();
    private final Map<String, StepDefinition> stepDefinitionsById = new HashMap<String, StepDefinition>();
    private final Set<Object> printedFeaturesAndRules = new HashSet<Object>();
    private final int afterFeatureIndent;
    private final int afterRuleIndent;

    PrettyReportData(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        this.afterFeatureIndent = PrettyReportData.calculateAfterFeatureIndent(features);
        this.afterRuleIndent = PrettyReportData.calculateAfterRuleIndent(features);
    }

    private static int calculateAfterRuleIndent(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        int indent = 0;
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE)) {
            indent += 2;
        }
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_RULE_LINE)) {
            indent += 2;
        }
        return indent;
    }

    private static int calculateAfterFeatureIndent(Set<MessagesToPrettyWriter.PrettyFeature> features) {
        int indent = 0;
        if (features.contains((Object)MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE)) {
            indent += 2;
        }
        return indent;
    }

    private static int calculateStepLineLength(int scenarioIndent, Step step, PickleStep pickleStep) {
        String keyword = step.getKeyword();
        String text = pickleStep.getText();
        return scenarioIndent + 2 + keyword.length() + text.length();
    }

    private static int calculateScenarioLineLength(int scenarioIndent, Pickle pickle, Scenario scenario) {
        String pickleName = pickle.getName();
        String pickleKeyword = scenario.getKeyword();
        return scenarioIndent + pickleKeyword.length() + 2 + pickleName.length();
    }

    private int calculateScenarioIndent(Lineage lineage) {
        if (lineage.rule().isPresent()) {
            return this.afterRuleIndent;
        }
        if (lineage.feature().isPresent()) {
            return this.afterFeatureIndent;
        }
        return 0;
    }

    void collect(Envelope envelope) {
        this.query.update(envelope);
        envelope.getStepDefinition().ifPresent(this::updateStepDefinitionsById);
        envelope.getTestCaseStarted().ifPresent(this::preCalculateLocationIndent);
    }

    private void updateStepDefinitionsById(StepDefinition stepDefinition) {
        this.stepDefinitionsById.put(stepDefinition.getId(), stepDefinition);
    }

    private void preCalculateLocationIndent(TestCaseStarted event) {
        this.query.findLineageBy(event).ifPresent(lineage -> lineage.scenario().ifPresent(scenario -> this.query.findPickleBy(event).ifPresent(pickle -> {
            int scenarioIndent = this.calculateScenarioIndent((Lineage)lineage);
            int scenarioLineLength = PrettyReportData.calculateScenarioLineLength(scenarioIndent, pickle, scenario);
            int longestLine = pickle.getSteps().stream().mapToInt(pickleStep -> this.preCalculatePickleStepLineLength(scenarioIndent, (PickleStep)pickleStep)).reduce(scenarioLineLength, Math::max);
            this.scenarioIndentByTestCaseStartedId.put(event.getId(), scenarioIndent);
            this.commentStartIndexByTestCaseStartedId.put(event.getId(), longestLine + 1);
        })));
    }

    private Integer preCalculatePickleStepLineLength(int indent, PickleStep pickleStep) {
        return this.query.findStepBy(pickleStep).map(step -> PrettyReportData.calculateStepLineLength(indent, step, pickleStep)).orElse(0);
    }

    int getAfterFeatureIndent() {
        return this.afterFeatureIndent;
    }

    int getAttachmentIndentBy(Attachment attachment) {
        return attachment.getTestCaseStartedId().map(s -> this.scenarioIndentByTestCaseStartedId.getOrDefault(s, 0) + 4).orElse(4);
    }

    int getScenarioIndentBy(TestCaseStarted testCaseStarted) {
        return this.scenarioIndentByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), 0);
    }

    int getStepIndentBy(TestStepFinished testStepFinished) {
        return this.scenarioIndentByTestCaseStartedId.getOrDefault(testStepFinished.getTestCaseStartedId(), 0) + 2;
    }

    int getStackTraceIndentBy(TestStepFinished testStepFinished) {
        return this.getStepIndentBy(testStepFinished) + 4;
    }

    int getArgumentIndentBy(TestStepFinished testStepFinished) {
        return this.getStepIndentBy(testStepFinished) + 2;
    }

    int getCommentStartAtIndexBy(TestCaseStarted testCaseStarted) {
        return this.getCommentStartAtIndexBy(testCaseStarted.getId());
    }

    int getCommentStartAtIndexBy(TestStepFinished testStepFinished) {
        return this.getCommentStartAtIndexBy(testStepFinished.getTestCaseStartedId());
    }

    private int getCommentStartAtIndexBy(String testCaseStartedId) {
        return this.commentStartIndexByTestCaseStartedId.getOrDefault(testCaseStartedId, 0);
    }

    Optional<List<PickleTag>> findTagsBy(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted).map(Pickle::getTags).filter(pickleTags -> !pickleTags.isEmpty());
    }

    Optional<Scenario> findScenarioBy(Pickle pickle) {
        return this.query.findLineageBy(pickle).flatMap(Lineage::scenario);
    }

    Optional<TestStep> findTestStepBy(TestStepFinished event) {
        return this.query.findTestStepBy(event);
    }

    Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        return this.query.findPickleStepBy(testStep);
    }

    Optional<Step> findStepBy(PickleStep pickleStep) {
        return this.query.findStepBy(pickleStep);
    }

    Optional<SourceReference> findSourceReferenceBy(TestStep testStep) {
        return testStep.getStepDefinitionIds().filter(ids -> ids.size() == 1).map(ids -> this.stepDefinitionsById.get(ids.get(0))).map(StepDefinition::getSourceReference);
    }

    Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted);
    }

    Optional<Long> findLineOf(Pickle pickle) {
        return this.query.findLocationOf(pickle).map(Location::getLine);
    }

    Optional<Lineage> findLineageBy(TestCaseStarted event) {
        return this.query.findLineageBy(event);
    }

    void ifNotSeenBefore(Feature feature, Runnable print) {
        if (this.printedFeaturesAndRules.add(feature)) {
            print.run();
        }
    }

    void ifNotSeenBefore(Rule rule, Runnable print) {
        if (this.printedFeaturesAndRules.add(rule)) {
            print.run();
        }
    }
}

