/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;

public final class TestCaseFinished {
    private final String testCaseStartedId;
    private final Timestamp timestamp;
    private final Boolean willBeRetried;

    public TestCaseFinished(String testCaseStartedId, Timestamp timestamp, Boolean willBeRetried) {
        this.testCaseStartedId = Objects.requireNonNull(testCaseStartedId, "TestCaseFinished.testCaseStartedId cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "TestCaseFinished.timestamp cannot be null");
        this.willBeRetried = Objects.requireNonNull(willBeRetried, "TestCaseFinished.willBeRetried cannot be null");
    }

    public String getTestCaseStartedId() {
        return this.testCaseStartedId;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Boolean getWillBeRetried() {
        return this.willBeRetried;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseFinished that = (TestCaseFinished)o;
        return this.testCaseStartedId.equals(that.testCaseStartedId) && this.timestamp.equals(that.timestamp) && this.willBeRetried.equals(that.willBeRetried);
    }

    public int hashCode() {
        return Objects.hash(this.testCaseStartedId, this.timestamp, this.willBeRetried);
    }

    public String toString() {
        return "TestCaseFinished{testCaseStartedId=" + this.testCaseStartedId + ", timestamp=" + String.valueOf(this.timestamp) + ", willBeRetried=" + this.willBeRetried + "}";
    }
}

