/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;
import java.util.Optional;

public final class Location {
    private final Long line;
    private final Long column;

    public Location(Long line, Long column) {
        this.line = Objects.requireNonNull(line, "Location.line cannot be null");
        this.column = column;
    }

    public Long getLine() {
        return this.line;
    }

    public Optional<Long> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location that = (Location)o;
        return this.line.equals(that.line) && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return "Location{line=" + this.line + ", column=" + this.column + '}';
    }
}

