
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * //// TestCases
 * 
 * *
 *  A `TestCase` contains a sequence of `TestStep`s.
 * 
 */
public class TestCase {

    /**
     * 
     * (Required)
     * 
     */
    private String id;
    /**
     * The ID of the `Pickle` this `TestCase` is derived from.
     * (Required)
     * 
     */
    private String pickleId;
    /**
     * 
     * (Required)
     * 
     */
    private List<TestStep> testSteps = new ArrayList<TestStep>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestCase() {
    }

    /**
     * 
     * @param testSteps
     * @param id
     * @param pickleId
     */
    public TestCase(String id, String pickleId, List<TestStep> testSteps) {
        super();
        this.id = id;
        this.pickleId = pickleId;
        this.testSteps = testSteps;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * The ID of the `Pickle` this `TestCase` is derived from.
     * (Required)
     * 
     */
    public String getPickleId() {
        return pickleId;
    }

    /**
     * The ID of the `Pickle` this `TestCase` is derived from.
     * (Required)
     * 
     */
    public void setPickleId(String pickleId) {
        this.pickleId = pickleId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<TestStep> getTestSteps() {
        return testSteps;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTestSteps(List<TestStep> testSteps) {
        this.testSteps = testSteps;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCase.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("pickleId");
        sb.append('=');
        sb.append(((this.pickleId == null)?"<null>":this.pickleId));
        sb.append(',');
        sb.append("testSteps");
        sb.append('=');
        sb.append(((this.testSteps == null)?"<null>":this.testSteps));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.testSteps == null)? 0 :this.testSteps.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.pickleId == null)? 0 :this.pickleId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestCase) == false) {
            return false;
        }
        TestCase rhs = ((TestCase) other);
        return ((((this.testSteps == rhs.testSteps)||((this.testSteps!= null)&&this.testSteps.equals(rhs.testSteps)))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.pickleId == rhs.pickleId)||((this.pickleId!= null)&&this.pickleId.equals(rhs.pickleId))));
    }

}
