
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class PickleTableRow {

    /**
     * 
     * (Required)
     * 
     */
    private List<PickleTableCell> cells = new ArrayList<PickleTableCell>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleTableRow() {
    }

    /**
     * 
     * @param cells
     */
    public PickleTableRow(List<PickleTableCell> cells) {
        super();
        this.cells = cells;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<PickleTableCell> getCells() {
        return cells;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setCells(List<PickleTableCell> cells) {
        this.cells = cells;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleTableRow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("cells");
        sb.append('=');
        sb.append(((this.cells == null)?"<null>":this.cells));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.cells == null)? 0 :this.cells.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleTableRow) == false) {
            return false;
        }
        PickleTableRow rhs = ((PickleTableRow) other);
        return ((this.cells == rhs.cells)||((this.cells!= null)&&this.cells.equals(rhs.cells)));
    }

}
