
package io.cucumber.messages.types;


public class PickleTableCell {

    /**
     * 
     * (Required)
     * 
     */
    private String value;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleTableCell() {
    }

    /**
     * 
     * @param value
     */
    public PickleTableCell(String value) {
        super();
        this.value = value;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getValue() {
        return value;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleTableCell.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleTableCell) == false) {
            return false;
        }
        PickleTableCell rhs = ((PickleTableCell) other);
        return ((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value)));
    }

}
