
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * *
 *  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
 *  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
 *  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
 * 
 *  The only consumers of `GherkinDocument` should only be formatters that produce
 *  "rich" output, resembling the original Gherkin document.
 * 
 */
public class GherkinDocument {

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * 
     */
    private String uri;
    private Feature feature;
    /**
     * All the comments in the Gherkin document
     * (Required)
     * 
     */
    private List<Comment> comments = new ArrayList<Comment>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public GherkinDocument() {
    }

    /**
     * 
     * @param comments
     * @param feature
     * @param uri
     */
    public GherkinDocument(String uri, Feature feature, List<Comment> comments) {
        super();
        this.uri = uri;
        this.feature = feature;
        this.comments = comments;
    }

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * 
     */
    public String getUri() {
        return uri;
    }

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * 
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    public Feature getFeature() {
        return feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    /**
     * All the comments in the Gherkin document
     * (Required)
     * 
     */
    public List<Comment> getComments() {
        return comments;
    }

    /**
     * All the comments in the Gherkin document
     * (Required)
     * 
     */
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GherkinDocument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uri");
        sb.append('=');
        sb.append(((this.uri == null)?"<null>":this.uri));
        sb.append(',');
        sb.append("feature");
        sb.append('=');
        sb.append(((this.feature == null)?"<null>":this.feature));
        sb.append(',');
        sb.append("comments");
        sb.append('=');
        sb.append(((this.comments == null)?"<null>":this.comments));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.comments == null)? 0 :this.comments.hashCode()));
        result = ((result* 31)+((this.feature == null)? 0 :this.feature.hashCode()));
        result = ((result* 31)+((this.uri == null)? 0 :this.uri.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GherkinDocument) == false) {
            return false;
        }
        GherkinDocument rhs = ((GherkinDocument) other);
        return ((((this.comments == rhs.comments)||((this.comments!= null)&&this.comments.equals(rhs.comments)))&&((this.feature == rhs.feature)||((this.feature!= null)&&this.feature.equals(rhs.feature))))&&((this.uri == rhs.uri)||((this.uri!= null)&&this.uri.equals(rhs.uri))));
    }

}
