
package io.cucumber.messages.types;


public class DocString {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    private String mediaType;
    /**
     * 
     * (Required)
     * 
     */
    private String content;
    /**
     * 
     * (Required)
     * 
     */
    private String delimiter;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DocString() {
    }

    /**
     * 
     * @param delimiter
     * @param location
     * @param mediaType
     * @param content
     */
    public DocString(Location location, String mediaType, String content, String delimiter) {
        super();
        this.location = location;
        this.mediaType = mediaType;
        this.content = content;
        this.delimiter = delimiter;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getContent() {
        return content;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getDelimiter() {
        return delimiter;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DocString.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(((this.mediaType == null)?"<null>":this.mediaType));
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(((this.content == null)?"<null>":this.content));
        sb.append(',');
        sb.append("delimiter");
        sb.append('=');
        sb.append(((this.delimiter == null)?"<null>":this.delimiter));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.mediaType == null)? 0 :this.mediaType.hashCode()));
        result = ((result* 31)+((this.content == null)? 0 :this.content.hashCode()));
        result = ((result* 31)+((this.delimiter == null)? 0 :this.delimiter.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DocString) == false) {
            return false;
        }
        DocString rhs = ((DocString) other);
        return (((((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location)))&&((this.mediaType == rhs.mediaType)||((this.mediaType!= null)&&this.mediaType.equals(rhs.mediaType))))&&((this.content == rhs.content)||((this.content!= null)&&this.content.equals(rhs.content))))&&((this.delimiter == rhs.delimiter)||((this.delimiter!= null)&&this.delimiter.equals(rhs.delimiter))));
    }

}
